/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import junit.framework.Assert;
import org.codehaus.nanning.prevayler.FilterPrevayler;
import org.codehaus.nanning.prevayler.InvokeCommand;
import org.prevayler.Prevayler;
import org.prevayler.Transaction;

public class CountingPrevayler
extends FilterPrevayler {
    private int numberOfTransactionsInLog = 0;
    private StringBuffer transactionLog;

    public CountingPrevayler(Prevayler prevayler) {
        super(prevayler);
    }

    public void setLogTransactionMethods(boolean flag) {
        this.transactionLog = flag ? new StringBuffer() : null;
    }

    public void execute(Transaction transaction) {
        ++this.numberOfTransactionsInLog;
        if (this.transactionLog != null && transaction instanceof InvokeCommand) {
            InvokeCommand invokeCommand = (InvokeCommand)transaction;
            if (this.transactionLog.length() != 0) {
                this.transactionLog.append(" ");
            }
            this.transactionLog.append(invokeCommand.getCall().getMethod().getName());
        }
        super.execute(transaction);
    }

    public void assertNumberOfCommands(String message, int expectedNumber) {
        Assert.assertEquals((String)(message + ", wrong number of commands in log"), (int)expectedNumber, (int)this.numberOfTransactionsInLog);
    }

    public void assertNumberOfCommands(int expectedNumber) {
        Assert.assertEquals((String)"wrong number of commands in log", (int)expectedNumber, (int)this.numberOfTransactionsInLog);
    }

    public int getNumberOfTransactionsInLog() {
        return this.numberOfTransactionsInLog;
    }

    public void resetCount() {
        this.numberOfTransactionsInLog = 0;
        if (this.transactionLog != null) {
            this.transactionLog = new StringBuffer();
        }
    }

    public String getTransactionLog() {
        return this.transactionLog.toString();
    }
}

