/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import java.io.File;
import java.io.IOException;
import org.prevayler.Prevayler;
import org.prevayler.Transaction;
import org.prevayler.foundation.FileManager;
import org.prevayler.implementation.TransactionSubscriber;
import org.prevayler.implementation.log.TransactionLogger;

public class CheckpointPrevayler
implements Prevayler {
    private Object prevalentSystem;
    private long systemVersion = 0L;
    private CheckPointTransactionLogger publisher;
    private File directory;
    private TransactionSubscriber subscriber;

    public CheckpointPrevayler(Object newPrevalentSystem, String prevalenceBase) throws IOException, ClassNotFoundException {
        this.directory = FileManager.produceDirectory((String)prevalenceBase);
        this.systemVersion = this.latestVersion();
        this.prevalentSystem = newPrevalentSystem;
        this.publisher = new CheckPointTransactionLogger(prevalenceBase);
        this.subscriber = new TransactionSubscriber(){

            public synchronized void receive(Transaction transaction) {
                CheckpointPrevayler.this.systemVersion++;
                transaction.executeOn(CheckpointPrevayler.this.prevalentSystem);
            }
        };
        this.publisher.addSubscriber(this.subscriber, this.systemVersion + 1L);
    }

    public Object prevalentSystem() {
        return this.prevalentSystem;
    }

    public void execute(Transaction transaction) {
        this.publisher.publish(transaction);
    }

    private long latestVersion() throws IOException {
        String[] fileNames = this.directory.list();
        if (fileNames == null) {
            throw new IOException("Error reading file list from directory " + this.directory);
        }
        long result = 0L;
        int i = 0;
        while (i < fileNames.length) {
            long candidate = this.version(fileNames[i]);
            if (candidate > result) {
                result = candidate;
            }
            ++i;
        }
        return result;
    }

    private long version(String fileName) {
        if (!fileName.endsWith("." + this.suffix())) {
            return -1L;
        }
        return Long.parseLong(fileName.substring(0, fileName.indexOf("." + this.suffix())));
    }

    private String suffix() {
        return "transactionLog";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        TransactionSubscriber transactionSubscriber = this.subscriber;
        synchronized (transactionSubscriber) {
            this.publisher.startNewCheckpointFile();
        }
    }

    private class CheckPointTransactionLogger
    extends TransactionLogger {
        public CheckPointTransactionLogger(String prevalenceBase) throws ClassNotFoundException, IOException {
            super(prevalenceBase);
        }

        protected Transaction transactionFromLogEntry(Object entry) {
            if (entry instanceof Transaction) {
                return (Transaction)entry;
            }
            CheckpointPrevayler.this.prevalentSystem = entry;
            return new Transaction(this){
                private final /* synthetic */ CheckPointTransactionLogger this$1;
                {
                    this.this$1 = this$1;
                }

                public void executeOn(Object prevalentSystem) {
                }
            };
        }

        public void startNewCheckpointFile() {
            this.createNewOutputLog();
        }

        protected void createNewOutputLog() {
            super.createNewOutputLog();
            this.outputToLog(CheckpointPrevayler.this.prevalentSystem);
        }
    }
}

