/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import org.codehaus.nanning.Invocation;
import org.codehaus.nanning.MethodInterceptor;

public class CheckTransactionUnsupportedInterceptor
implements MethodInterceptor {
    private static ThreadLocal transactionsUnsupported = new ThreadLocal();

    static boolean isTransactionsSupported() {
        return transactionsUnsupported.get() == null;
    }

    static void enterTransactionsUnsupported() {
        transactionsUnsupported.set(transactionsUnsupported);
    }

    static void exitTransactionsUnsupported() {
        transactionsUnsupported.set(null);
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (!CheckTransactionUnsupportedInterceptor.isTransactionsSupported()) {
            throw new IllegalStateException("Transactions are not supported in the current calling context.");
        }
        return invocation.invokeNext();
    }
}

