/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.nanning.Invocation;

public class Call
implements Serializable {
    static final long serialVersionUID = -3336463259251779539L;
    protected Object target;
    protected Object[] args;
    private Object classIdentifier;
    private Class interfaceClass;
    private Class[] parameterTypes;
    private String methodName;

    public Call(Invocation invocation) throws Exception {
        this.setInvocation(invocation);
    }

    public Call() {
    }

    protected void setInvocation(Invocation invocation) throws Exception {
        this.classIdentifier = invocation.getAspectInstance().getClassIdentifier();
        this.interfaceClass = invocation.getTargetInterface();
        this.methodName = invocation.getMethod().getName();
        this.parameterTypes = invocation.getMethod().getParameterTypes();
        this.target = invocation.getProxy();
        this.args = invocation.getArgs();
    }

    public Method getMethod() {
        try {
            return this.interfaceClass.getMethod(this.methodName, this.parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException("did not find method " + this.methodName + " returning null", e);
        }
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public Object getClassIdentifier() {
        return this.classIdentifier;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object invoke() throws Exception {
        Method method = this.getMethod();
        Object target = this.getTarget();
        Object[] args = this.getArgs();
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
    }
}

