/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.nanning.prevayler.CurrentPrevayler;
import org.codehaus.nanning.prevayler.IdentifyingSystem;
import org.codehaus.nanning.prevayler.SoftMap;
import org.prevayler.util.clock.AbstractClockedSystem;

public class BasicIdentifyingSystem
extends AbstractClockedSystem
implements IdentifyingSystem {
    private static final Log logger;
    static final long serialVersionUID = 4503034161857395426L;
    private Map idToObject = SoftMap.createSoftValuesMap();
    private Map objectToId = SoftMap.createSoftKeysMap();
    private long nextObjectId = 0L;
    static /* synthetic */ Class class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void rebuildKeysMap() {
        this.objectToId = SoftMap.createSoftKeysMap();
        Iterator iterator = this.idToObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long id = (Long)entry.getKey();
            Object o = entry.getValue();
            this.objectToId.put(o, id);
        }
    }

    public synchronized Object getObjectWithID(long oid) {
        Object object = this.idToObject.get(new Long(oid));
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError((Object)("could not find object with id " + oid));
        }
        if (!$assertionsDisabled && !this.hasObjectID(object)) {
            throw new AssertionError((Object)("object is not registered " + object));
        }
        return object;
    }

    public synchronized long getObjectID(Object object) {
        if (!$assertionsDisabled && !this.hasObjectID(object)) {
            throw new AssertionError((Object)("object " + object + " had no object id, use registerObjectID(Object)"));
        }
        return (Long)this.objectToId.get(object);
    }

    public synchronized boolean hasNoRegisteredObjects() {
        return this.objectToId.isEmpty();
    }

    public synchronized Collection getAllRegisteredObjects() {
        ArrayList result = new ArrayList();
        Iterator i = this.objectToId.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Map.Entry entry = i.next();
                result.add(entry.getKey());
            }
            catch (NoSuchElementException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public synchronized boolean hasObjectID(Object object) {
        return this.objectToId.containsKey(object);
    }

    public synchronized boolean isIDRegistered(long objectId) {
        return this.idToObject.containsKey(new Long(objectId));
    }

    public synchronized long registerObjectID(Object object) {
        if (!CurrentPrevayler.isInTransaction()) {
            throw new IllegalStateException("You have to be inside a transaction to register objects");
        }
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError((Object)"can't register null");
        }
        if (!$assertionsDisabled && this.hasObjectID(object)) {
            throw new AssertionError((Object)("already has ID: " + object));
        }
        Long id = this.getNextId();
        if (!$assertionsDisabled && this.isIDRegistered(id)) {
            throw new AssertionError();
        }
        this.idToObject.put(id, object);
        this.objectToId.put(object, id);
        logger.debug((Object)("registering object " + object + " with id " + id));
        return id;
    }

    private synchronized Long getNextId() {
        return new Long(this.nextObjectId++);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem == null ? (class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem = BasicIdentifyingSystem.class$("org.codehaus.nanning.prevayler.BasicIdentifyingSystem")) : class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem).desiredAssertionStatus();
        logger = LogFactory.getLog((Class)(class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem == null ? (class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem = BasicIdentifyingSystem.class$("org.codehaus.nanning.prevayler.BasicIdentifyingSystem")) : class$org$codehaus$nanning$prevayler$BasicIdentifyingSystem));
    }
}

