/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.codehaus.nanning.Invocation;
import org.codehaus.nanning.prevayler.Call;

public class AuthenticatedCall
extends Call {
    static final long serialVersionUID = 8405907347881334801L;
    protected Set principals;
    protected Set privateCredentials;
    protected Set publicCredentials;
    private static final Predicate isSerializable = new Predicate(){

        public boolean evaluate(Object o) {
            return o instanceof Serializable;
        }
    };

    public AuthenticatedCall() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            this.principals = new HashSet<Principal>(subject.getPrincipals());
            CollectionUtils.filter((Collection)this.principals, (Predicate)isSerializable);
            this.privateCredentials = new HashSet<Object>(subject.getPrivateCredentials());
            CollectionUtils.filter((Collection)this.privateCredentials, (Predicate)isSerializable);
            this.publicCredentials = new HashSet<Object>(subject.getPublicCredentials());
            CollectionUtils.filter((Collection)this.publicCredentials, (Predicate)isSerializable);
        }
    }

    public AuthenticatedCall(Invocation invocation) throws Exception {
        this();
        this.setInvocation(invocation);
    }

    public Subject getSubject() {
        if (this.principals == null && this.publicCredentials == null && this.privateCredentials == null) {
            return null;
        }
        return new Subject(false, this.principals == null ? new HashSet() : this.principals, this.publicCredentials == null ? new HashSet() : this.publicCredentials, this.privateCredentials == null ? new HashSet() : this.privateCredentials);
    }

    public Object invoke() throws Exception {
        try {
            return Subject.doAs(this.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthenticatedCall.super.invoke();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

