/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.api.classes_processing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProcessContext
extends Closeable {
    @NotNull
    public File getClassesDir();

    @NotNull
    public List<File> getClasspath();

    @NotNull
    public ClassLoader getClasspathClassLoader();

    default public boolean doesResourceExist(@NotNull String relativePath) {
        return this.readBinaryResource(relativePath) != null;
    }

    @Nullable
    public byte[] readBinaryResource(@NotNull String var1);

    @Nullable
    public String readTextResource(@NotNull String var1);

    public void writeBinaryResource(@NotNull String var1, @NotNull byte[] var2);

    public void writeTextResource(@NotNull String var1, @NotNull String var2);

    public void appendTextResource(@NotNull String var1, @NotNull String var2);

    default public void writeService(@NotNull String serviceName, @NotNull String implementationName) {
        this.appendTextResource("META-INF/services/" + serviceName, "\n" + implementationName);
    }

    default public void writeService(@NotNull Class<?> serviceClass, @NotNull String implementationName) {
        this.writeService(serviceClass.getName(), implementationName);
    }

    default public void writeService(@NotNull String serviceName, @NotNull Class<?> implementationClass) {
        this.writeService(serviceName, implementationClass.getName());
    }

    default public void writeService(@NotNull Class<?> serviceClass, @NotNull Class<?> implementationClass) {
        this.writeService(serviceClass.getName(), implementationClass.getName());
    }

    default public boolean doesClasspathResourceExist(@NotNull String relativePath) {
        return this.readClasspathBinaryResource(relativePath) != null;
    }

    @Nullable
    public byte[] readClasspathBinaryResource(@NotNull String var1);

    @Nullable
    public String readClasspathTextResource(@NotNull String var1);

    @Override
    default public void close() throws IOException {
        ClassLoader classpathClassLoader = this.getClasspathClassLoader();
        if (classpathClassLoader instanceof Closeable) {
            ((Closeable)((Object)classpathClassLoader)).close();
        }
    }
}

