package name.remal.gradle_plugins.api.classes_processing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface ProcessContext extends Closeable {

    @NotNull
    File getClassesDir();

    @NotNull
    List<File> getClasspath();

    @NotNull
    ClassLoader getClasspathClassLoader();

    default boolean doesResourceExist(@NotNull String relativePath) {
        return readBinaryResource(relativePath) != null;
    }

    @Nullable
    byte[] readBinaryResource(@NotNull String relativePath);

    @Nullable
    String readTextResource(@NotNull String relativePath);

    void writeBinaryResource(@NotNull String relativePath, @NotNull byte[] content);

    void writeTextResource(@NotNull String relativePath, @NotNull String text);

    void appendTextResource(@NotNull String relativePath, @NotNull String text);

    default void writeService(@NotNull String serviceName, @NotNull String implementationName) {
        appendTextResource("META-INF/services/" + serviceName, "\n" + implementationName);
    }

    default void writeService(@NotNull Class<?> serviceClass, @NotNull String implementationName) {
        writeService(serviceClass.getName(), implementationName);
    }

    default void writeService(@NotNull String serviceName, @NotNull Class<?> implementationClass) {
        writeService(serviceName, implementationClass.getName());
    }

    default void writeService(@NotNull Class<?> serviceClass, @NotNull Class<?> implementationClass) {
        writeService(serviceClass.getName(), implementationClass.getName());
    }

    default boolean doesClasspathResourceExist(@NotNull String relativePath) {
        return readClasspathBinaryResource(relativePath) != null;
    }

    @Nullable
    byte[] readClasspathBinaryResource(@NotNull String relativePath);

    @Nullable
    String readClasspathTextResource(@NotNull String relativePath);


    @Override
    default void close() throws IOException {
        ClassLoader classpathClassLoader = getClasspathClassLoader();
        if (classpathClassLoader instanceof Closeable) {
            ((Closeable) classpathClassLoader).close();
        }
    }

}
