package name.remal.gradle_plugins.api;

import org.jetbrains.annotations.NotNull;

import java.util.Map;

@SuppressWarnings({"unused", "squid:S1192"})
public final class BuildTimeConstants {

    /**
     * Invocation of this method will be replaced with actual class name. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassName(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual class simple name. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassSimpleName(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual class simple name. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassPackageName(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual class internal name. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassInternalName(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual class descriptor. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassDescriptor(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }


    /**
     * Invocation of this method will be replaced with actual property value. <b>Property name parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getStringProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value parsed as int. <b>Property name parameter must be a constant expression</b>.
     */
    public static int getIntegerProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value parsed as long. <b>Property name parameter must be a constant expression</b>.
     */
    public static long getLongProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value parsed as boolean. <b>Property name parameter must be a constant expression</b>.
     */
    public static boolean getBooleanProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }


    /**
     * Invocation of this method will be replaced with actual properties values. <b>Property name parameter must be a constant expression</b>.
     */
    @NotNull
    public static Map<String, String> getStringProperties(@NotNull String propertyPattern) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual properties values parsed as int. <b>Property name parameter must be a constant expression</b>.
     */
    @NotNull
    public static Map<String, Integer> getIntegerProperties(@NotNull String propertyPattern) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual properties values parsed as long. <b>Property name parameter must be a constant expression</b>.
     */
    @NotNull
    public static Map<String, Long> getLongProperties(@NotNull String propertyPattern) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual properties values parsed as boolean. <b>Property name parameter must be a constant expression</b>.
     */
    @NotNull
    public static Map<String, Boolean> getBooleanProperties(@NotNull String propertyPattern) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process the method invocation.");
    }


    private BuildTimeConstants() {
    }

    static {
        throwIllegalClassUseException();
    }

    private static void throwIllegalClassUseException() {
        throw new UnsupportedOperationException("This class can't be used directly. Use 'remal.name.classes-processing' Gradle plugin to handle the class's methods.");
    }

}
