package com.example.microsoftgraphpickers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.extensions.IUserCollectionPage;
import com.microsoft.graph.extensions.User;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.serializer.DefaultSerializer;

import java.util.ArrayList;
import java.util.List;

public class GraphUserSearch extends Activity {

    RecyclerView rvUserList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.graphpickers__activity_graph_user_search);
        rvUserList = (RecyclerView) findViewById(R.id.user_list);
        rvUserList.setLayoutManager(new LinearLayoutManager(getApplicationContext(), LinearLayoutManager.VERTICAL, false));
        getUsers();
        rvUserList.addOnItemTouchListener(
                new RecyclerItemClickListener(getApplicationContext(), new RecyclerItemClickListener.OnItemClickListener() {
                    @Override public void onItemClick(View view, int position) {
                        User user = ((UserListAdapter) rvUserList.getAdapter()).getItem(position);

                        DefaultSerializer a = new DefaultSerializer(new DefaultLogger());
                        String b = a.serializeObject(user);

                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("user", b);
                        setResult(Activity.RESULT_OK, returnIntent);
                        finish();
                    }
                })
        );

    }


    public void getUsers() {
        List<Option> options = new ArrayList<>();

        options.add(new QueryOption("$filter", "startswith(displayName,'dan s') and accountEnabled eq true and userType eq 'Member'"));
        GraphPickerLib.getClient()
                .getUsers()
                .buildRequest(options)
                .get(new ICallback<IUserCollectionPage>() {
                    @Override
                    public void success(IUserCollectionPage iUserCollectionPage) {
                        List<User> users = iUserCollectionPage.getCurrentPage();

                        UserListAdapter adapter = new UserListAdapter(users);
                        rvUserList.setAdapter(adapter);
                    }

                    @Override
                    public void failure(ClientException ex) {
                        Log.e(GraphPickerLib.TAG, ex.toString());
                    }
                });




    }

    public static User getUser(Intent data) {
        String userJSON = data.getStringExtra("user");
        DefaultSerializer a = new DefaultSerializer(new DefaultLogger());
        return a.deserializeObject(userJSON, User.class);
    }


    public static class IntentBuilder {
        public Intent build(Context context) {
            return new Intent(context, GraphUserSearch.class);
        }
    }
}
