/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.responses;

import java.sql.SQLException;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.IIncompleteResponse;

public class ResultSetResponse
implements IIncompleteResponse {
    private static final byte IS_SET_FINAL_VALUE = 15;
    private final int rowcount;
    private final int tuplecount;
    private int cacheSize;
    private final int id;
    private final String[] name;
    private final String[] type;
    private final int[] JdbcSQLTypes;
    private final int[] columnLengths;
    private final String[] tableNames;
    private final int seqnr;
    private byte isSet;
    private boolean closed;
    private MonetConnection con;
    private MonetConnection.ResponseList parent;
    private boolean cacheSizeSetExplicitly = false;
    private boolean destroyOnClose;
    private int blockOffset = 0;
    private final AbstractDataBlockResponse[] resultBlocks;

    public ResultSetResponse(MonetConnection con, MonetConnection.ResponseList parent, int id, int seq, int rowcount, int tuplecount, int columncount) {
        this.con = con;
        this.parent = parent;
        if (parent.getCachesize() == 0) {
            this.cacheSize = con.getDefFetchsize();
            this.cacheSizeSetExplicitly = false;
        } else {
            this.cacheSize = parent.getCachesize();
            this.cacheSizeSetExplicitly = true;
        }
        if (rowcount > this.cacheSize) {
            this.cacheSize = rowcount;
        }
        this.seqnr = seq;
        this.destroyOnClose = id > 0 && tuplecount > rowcount;
        this.id = id;
        this.rowcount = rowcount;
        int maxrows = parent.getMaxrows();
        this.tuplecount = maxrows != 0 && tuplecount > maxrows ? maxrows : tuplecount;
        this.name = new String[columncount];
        this.type = new String[columncount];
        this.tableNames = new String[columncount];
        this.columnLengths = new int[columncount];
        this.JdbcSQLTypes = new int[columncount];
        this.resultBlocks = new AbstractDataBlockResponse[tuplecount / this.cacheSize + 1];
        this.resultBlocks[0] = con.getProtocol().getAnEmptyDataBlockResponse(rowcount, columncount, con.getProtocol(), this.JdbcSQLTypes);
    }

    private void populateJdbcSQLTypesArray() {
        for (int i = 0; i < this.type.length; ++i) {
            int javaSQLtype = MonetDriver.getJdbcSQLType(this.type[i]);
            if (javaSQLtype == 2004 && this.con.mapBlobAsVarBinary()) {
                javaSQLtype = -4;
            }
            if (javaSQLtype == 2005 && this.con.mapClobAsVarChar()) {
                javaSQLtype = -1;
            }
            this.JdbcSQLTypes[i] = javaSQLtype;
        }
    }

    @Override
    public boolean wantsMore() {
        return this.isSet < 15 || this.resultBlocks[0].wantsMore();
    }

    public AbstractDataBlockResponse addDataBlockResponse(int offset, int rowcount) {
        AbstractDataBlockResponse res;
        int block = (offset - this.blockOffset) / this.cacheSize;
        this.resultBlocks[block] = res = this.con.getProtocol().getAnEmptyDataBlockResponse(rowcount, this.getColumncount(), this.con.getProtocol(), this.JdbcSQLTypes);
        return res;
    }

    public int getId() {
        return this.id;
    }

    public int getColumncount() {
        return this.name.length;
    }

    public int getTuplecount() {
        return this.tuplecount;
    }

    public int getRowcount() {
        return this.rowcount;
    }

    public String[] getNames() {
        return this.name;
    }

    public String[] getTypes() {
        return this.type;
    }

    public int[] getJdbcSQLTypes() {
        return this.JdbcSQLTypes;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public int[] getColumnLengths() {
        return this.columnLengths;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getBlockOffset() {
        return this.blockOffset;
    }

    public int getRSType() {
        return this.parent.getRstype();
    }

    public int getRSConcur() {
        return this.parent.getRsconcur();
    }

    @Override
    public void addLines(AbstractProtocol protocol) throws ProtocolException {
        if (this.isSet >= 15) {
            this.resultBlocks[0].addLines(protocol);
        } else {
            int csrh = protocol.getCurrentServerResponse();
            if (csrh != 2) {
                throw new ProtocolException("header expected, got: " + protocol.getRemainingStringLine(0));
            }
            int next = this.con.getProtocol().getNextTableHeader(this.name, this.columnLengths, this.type, this.tableNames);
            this.isSet = (byte)(this.isSet | next);
            if (this.isSet >= 15) {
                this.populateJdbcSQLTypesArray();
            }
        }
    }

    public AbstractDataBlockResponse getDataBlockCorrespondingToLine(int row) throws SQLException {
        if (row >= this.tuplecount || row < 0) {
            return null;
        }
        int block = (row - this.blockOffset) / this.cacheSize;
        int blockLine = (row - this.blockOffset) % this.cacheSize;
        AbstractDataBlockResponse rawr = this.resultBlocks[block];
        if (rawr == null) {
            if (this.parent.getRstype() == 1003) {
                for (int i = 0; i < block; ++i) {
                    this.resultBlocks[i] = null;
                }
                if (MonetConnection.getSeqCounter() - 1 == this.seqnr && !this.cacheSizeSetExplicitly && this.tuplecount - row > this.cacheSize && this.cacheSize < this.con.getDefFetchsize() * 10) {
                    this.blockOffset += this.cacheSize;
                    this.cacheSize *= 10;
                    block = (row - this.blockOffset) / this.cacheSize;
                    blockLine = (row - this.blockOffset) % this.cacheSize;
                }
            }
            this.parent.executeQuery(this.con.getLanguage().getCommandTemplates(), "export " + this.id + " " + (block * this.cacheSize + this.blockOffset) + " " + this.cacheSize);
            rawr = this.resultBlocks[block];
            if (rawr == null) {
                throw new AssertionError((Object)("block " + block + " should have been fetched by now :("));
            }
        }
        rawr.setBlockLine(blockLine);
        return rawr;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.destroyOnClose) {
                this.con.sendControlCommand(4, this.id);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (AbstractDataBlockResponse r : this.resultBlocks) {
            if (r == null) continue;
            r.close();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

