/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol.oldmapi;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.mcl.connection.helpers.TimestampHelper;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiProtocol;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;

public class OldMapiDataBlockResponse
extends AbstractDataBlockResponse {
    private Object[] data;
    private int pos = -1;
    private int lastNanos;

    OldMapiDataBlockResponse(int rowcount, int columncount, AbstractProtocol protocol, int[] JdbcSQLTypes) {
        super(rowcount, protocol, JdbcSQLTypes);
        this.data = new Object[columncount];
    }

    @Override
    public void addLines(AbstractProtocol protocol) throws ProtocolException {
        int csrh = protocol.getCurrentServerResponse();
        if (csrh != 3) {
            throw new ProtocolException("protocol violation: unexpected line in data block: " + protocol.getRemainingStringLine(0));
        }
        if (this.pos == -1) {
            int numberOfColumns = this.data.length;
            block14: for (int i = 0; i < numberOfColumns; ++i) {
                switch (this.jdbcSQLTypes[i]) {
                    case 4: {
                        this.data[i] = new int[this.rowcount];
                        continue block14;
                    }
                    case -6: 
                    case 16: {
                        this.data[i] = new byte[this.rowcount];
                        continue block14;
                    }
                    case 5: {
                        this.data[i] = new short[this.rowcount];
                        continue block14;
                    }
                    case 7: {
                        this.data[i] = new float[this.rowcount];
                        continue block14;
                    }
                    case 8: {
                        this.data[i] = new double[this.rowcount];
                        continue block14;
                    }
                    case -5: {
                        this.data[i] = new long[this.rowcount];
                        continue block14;
                    }
                    case 91: 
                    case 92: 
                    case 2013: {
                        this.data[i] = new Calendar[this.rowcount];
                        continue block14;
                    }
                    case 93: 
                    case 2014: {
                        this.data[i] = new TimestampHelper[this.rowcount];
                        continue block14;
                    }
                    case 2: 
                    case 3: {
                        this.data[i] = new BigDecimal[this.rowcount];
                        continue block14;
                    }
                    case 2004: {
                        this.data[i] = new MonetBlob[this.rowcount];
                        continue block14;
                    }
                    case 2005: {
                        this.data[i] = new MonetClob[this.rowcount];
                        continue block14;
                    }
                    case -4: {
                        this.data[i] = new byte[this.rowcount][];
                        continue block14;
                    }
                    default: {
                        this.data[i] = new String[this.rowcount];
                    }
                }
            }
        }
        int nextPos = this.pos + 1;
        this.pos = ((OldMapiProtocol)this.protocol).parseTupleLines(nextPos, this.jdbcSQLTypes, this.data);
    }

    @Override
    public boolean wantsMore() {
        return this.pos + 1 < this.rowcount;
    }

    @Override
    public void close() {
        int numberOfColumns = this.data.length;
        for (int i = 0; i < numberOfColumns; ++i) {
            this.data[i] = null;
        }
        this.data = null;
    }

    private boolean checkValueIsNull(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case -6: 
            case 16: {
                this.lastReadWasNull = ((byte[])this.data[column])[this.blockLine] == -128;
                break;
            }
            case 5: {
                this.lastReadWasNull = ((short[])this.data[column])[this.blockLine] == Short.MIN_VALUE;
                break;
            }
            case 4: {
                this.lastReadWasNull = ((int[])this.data[column])[this.blockLine] == Integer.MIN_VALUE;
                break;
            }
            case -5: {
                this.lastReadWasNull = ((long[])this.data[column])[this.blockLine] == Long.MIN_VALUE;
                break;
            }
            case 7: {
                this.lastReadWasNull = ((float[])this.data[column])[this.blockLine] == Float.MIN_VALUE;
                break;
            }
            case 8: {
                this.lastReadWasNull = ((double[])this.data[column])[this.blockLine] == Double.MIN_VALUE;
                break;
            }
            default: {
                this.lastReadWasNull = ((Object[])this.data[column])[this.blockLine] == null;
            }
        }
        return this.lastReadWasNull;
    }

    @Override
    public boolean getBooleanValue(int column) {
        return !this.checkValueIsNull(column) && ((byte[])this.data[column])[this.blockLine] == 1;
    }

    @Override
    public byte getByteValue(int column) {
        if (this.checkValueIsNull(column)) {
            return 0;
        }
        return ((byte[])this.data[column])[this.blockLine];
    }

    @Override
    public short getShortValue(int column) {
        if (this.checkValueIsNull(column)) {
            return 0;
        }
        return ((short[])this.data[column])[this.blockLine];
    }

    @Override
    public int getIntValue(int column) {
        if (this.checkValueIsNull(column)) {
            return 0;
        }
        return ((int[])this.data[column])[this.blockLine];
    }

    @Override
    public long getLongValue(int column) {
        if (this.checkValueIsNull(column)) {
            return 0L;
        }
        return ((long[])this.data[column])[this.blockLine];
    }

    @Override
    public float getFloatValue(int column) {
        if (this.checkValueIsNull(column)) {
            return 0.0f;
        }
        return ((float[])this.data[column])[this.blockLine];
    }

    @Override
    public double getDoubleValue(int column) {
        if (this.checkValueIsNull(column)) {
            return 0.0;
        }
        return ((double[])this.data[column])[this.blockLine];
    }

    @Override
    public Object getObjectValue(int column) {
        if (this.checkValueIsNull(column)) {
            return null;
        }
        return ((Object[])this.data[column])[this.blockLine];
    }

    @Override
    public String getValueAsString(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                return ((String[])this.data[column])[this.blockLine];
            }
            case -4: {
                return Arrays.toString(((byte[][])this.data[column])[this.blockLine]);
            }
            case 16: {
                return ((byte[])this.data[column])[this.blockLine] == 1 ? "true" : "false";
            }
            case -6: {
                return Byte.toString(((byte[])this.data[column])[this.blockLine]);
            }
            case 5: {
                return Short.toString(((short[])this.data[column])[this.blockLine]);
            }
            case 4: {
                return Integer.toString(((int[])this.data[column])[this.blockLine]);
            }
            case -5: {
                return Long.toString(((long[])this.data[column])[this.blockLine]);
            }
            case 7: {
                return Float.toString(((float[])this.data[column])[this.blockLine]);
            }
            case 8: {
                return Double.toString(((double[])this.data[column])[this.blockLine]);
            }
            case 91: {
                Date aux1 = new Date(((Calendar[])this.data[column])[this.blockLine].getTimeInMillis());
                return this.protocol.getMonetDate().format(aux1);
            }
            case 92: {
                Time aux2 = new Time(((Calendar[])this.data[column])[this.blockLine].getTimeInMillis());
                return this.protocol.getMonetTimePrinter().format(aux2);
            }
            case 2013: {
                Time aux3 = new Time(((Calendar[])this.data[column])[this.blockLine].getTimeInMillis());
                return this.protocol.getMonetTimeTzPrinter().format(aux3);
            }
            case 93: {
                TimestampHelper thel = ((TimestampHelper[])this.data[column])[this.blockLine];
                Timestamp aux4 = thel.getTimestamp();
                this.lastNanos = thel.getNanoseconds();
                return this.protocol.getMonetTimestampPrinter().format(aux4);
            }
            case 2014: {
                TimestampHelper thelper = ((TimestampHelper[])this.data[column])[this.blockLine];
                Timestamp aux5 = thelper.getTimestamp();
                this.lastNanos = thelper.getNanoseconds();
                return this.protocol.getMonetTimestampTzPrinter().format(aux5);
            }
        }
        return ((Object[])this.data[column])[this.blockLine].toString();
    }

    @Override
    public Object getValueAsObject(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case 16: {
                return ((byte[])this.data[column])[this.blockLine] == 1;
            }
            case -6: {
                return ((byte[])this.data[column])[this.blockLine];
            }
            case 5: {
                return ((short[])this.data[column])[this.blockLine];
            }
            case 4: {
                return ((int[])this.data[column])[this.blockLine];
            }
            case -5: {
                return ((long[])this.data[column])[this.blockLine];
            }
            case 7: {
                return Float.valueOf(((float[])this.data[column])[this.blockLine]);
            }
            case 8: {
                return ((double[])this.data[column])[this.blockLine];
            }
            case 93: 
            case 2014: {
                TimestampHelper thelper = ((TimestampHelper[])this.data[column])[this.blockLine];
                this.lastNanos = thelper.getNanoseconds();
                return thelper.getCalendar();
            }
        }
        return ((Object[])this.data[column])[this.blockLine];
    }

    @Override
    public int getLastNanos() {
        return this.lastNanos;
    }
}

