/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection.mapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import nl.cwi.monetdb.mcl.connection.mapi.AbstractSocket;
import nl.cwi.monetdb.mcl.connection.mapi.MapiConnection;

public class OldMapiSocket
extends AbstractSocket {
    public static final int FULL_BLOCK = 8192;
    private static final int BLOCK = 8190;
    private final byte[] blklen = new byte[2];
    private final OldMapiBlockInputStream inStream = new OldMapiBlockInputStream(this.socket.getInputStream());
    private final OldMapiBlockOutputStream outStream = new OldMapiBlockOutputStream(this.socket.getOutputStream());

    OldMapiSocket(String hostname, int port, MapiConnection connection) throws IOException {
        super(hostname, port, connection);
    }

    @Override
    public int getFullBlockSize() {
        return 8192;
    }

    @Override
    public int getBlockSize() {
        return 8190;
    }

    @Override
    int readToBufferIn(ByteBuffer bufferIn) throws IOException {
        return this.inStream.read(bufferIn);
    }

    @Override
    int writeFromBufferOut(ByteBuffer bufferOut) throws IOException {
        return this.outStream.write(bufferOut);
    }

    @Override
    void flush() throws IOException {
        this.outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    class OldMapiBlockOutputStream {
        private final OutputStream outStream;
        private int writePos = 0;
        private byte[] block = new byte[8190];
        private int blocksize = 0;

        OldMapiBlockOutputStream(OutputStream out) {
            this.outStream = out;
        }

        void flush() throws IOException {
            this.writeBlock(true);
            this.outStream.flush();
        }

        void writeBlock(boolean last) throws IOException {
            if (last) {
                this.blocksize = (short)this.writePos;
                ((OldMapiSocket)OldMapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF | 1);
                ((OldMapiSocket)OldMapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            } else {
                this.blocksize = 8190;
                ((OldMapiSocket)OldMapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF);
                ((OldMapiSocket)OldMapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            }
            this.outStream.write(OldMapiSocket.this.blklen);
            this.outStream.write(this.block, 0, this.writePos);
            this.writePos = 0;
        }

        void write(int b) throws IOException {
            if (this.writePos == 8190) {
                this.writeBlock(false);
            }
            this.block[this.writePos++] = (byte)b;
        }

        int write(ByteBuffer b) throws IOException {
            return this.write(b, 0, b.position());
        }

        int write(ByteBuffer b, int off, int len) throws IOException {
            int written = 0;
            while (len > 0) {
                int t = 8190 - this.writePos;
                if (len > t) {
                    System.arraycopy(b.array(), off, this.block, this.writePos, t);
                    off += t;
                    len -= t;
                    this.writePos += t;
                    written += t;
                    this.writeBlock(false);
                    continue;
                }
                System.arraycopy(b.array(), off, this.block, this.writePos, len);
                this.writePos += len;
                written += len;
                break;
            }
            b.clear();
            return written;
        }

        public void close() throws IOException {
            this.outStream.close();
        }
    }

    private class OldMapiBlockInputStream {
        private final InputStream inStream;
        private int readPos = 0;
        private int blockLen = 0;
        private final byte[] block = new byte[8193];

        OldMapiBlockInputStream(InputStream in) {
            this.inStream = in;
        }

        public int available() {
            return this.blockLen - this.readPos;
        }

        private boolean _read(byte[] b, int len) throws IOException {
            int off = 0;
            while (len > 0) {
                int s = this.inStream.read(b, off, len);
                if (s == -1) {
                    if (off > 0) {
                        throw new IOException("Read from " + OldMapiSocket.this.connection.getHostname() + ":" + OldMapiSocket.this.connection.getPort() + ": Incomplete block read from stream");
                    }
                    return false;
                }
                len -= s;
                off += s;
            }
            return true;
        }

        private int readBlock() throws IOException {
            if (!this._read(OldMapiSocket.this.blklen, 2)) {
                return -1;
            }
            this.blockLen = (short)((OldMapiSocket.this.blklen[0] & 0xFF) >> 1 | (OldMapiSocket.this.blklen[1] & 0xFF) << 7);
            this.readPos = 0;
            if (this.blockLen > this.block.length) {
                throw new AssertionError((Object)("Server sent a block larger than BLOCKsize: " + this.blockLen + " > " + this.block.length));
            }
            if (!this._read(this.block, this.blockLen)) {
                return -1;
            }
            if ((OldMapiSocket.this.blklen[0] & 1) == 1) {
                if (this.blockLen > 0 && this.block[this.blockLen - 1] != 10) {
                    this.block[this.blockLen++] = 10;
                }
                this.block[this.blockLen++] = 46;
                this.block[this.blockLen++] = 10;
            }
            return this.blockLen;
        }

        public int read() throws IOException {
            if (this.available() == 0 && this.readBlock() == -1) {
                return -1;
            }
            return this.block[this.readPos++];
        }

        public int read(ByteBuffer b) throws IOException {
            return this.read(b, 0, b.capacity());
        }

        public int read(ByteBuffer b, int off, int len) throws IOException {
            int size;
            int t;
            b.clear();
            for (size = 0; size < len; size += t) {
                t = this.available();
                if (t == 0) {
                    if (size != 0) break;
                    if (this.readBlock() == -1) {
                        size = -1;
                        break;
                    }
                    t = this.available();
                }
                if (len > t) {
                    System.arraycopy(this.block, this.readPos, b.array(), off, t);
                    off += t;
                    len -= t;
                    this.readPos += t;
                    continue;
                }
                System.arraycopy(this.block, this.readPos, b.array(), off, len);
                this.readPos += len;
                size += len;
                break;
            }
            if (size == -1) {
                throw new IOException("Read from " + OldMapiSocket.this.connection.getHostname() + ":" + OldMapiSocket.this.connection.getPort() + ": Incomplete block read from stream");
            }
            b.position(size);
            b.flip();
            return size;
        }

        public long skip(long n) throws IOException {
            long skip = n;
            while (skip > 0L) {
                int t = this.available();
                if (skip > (long)t) {
                    skip -= (long)t;
                    this.readPos += t;
                    this.readBlock();
                    continue;
                }
                this.readPos = (int)((long)this.readPos + skip);
                break;
            }
            return n;
        }
    }
}

