/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection.helpers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.mcl.connection.helpers.TimestampHelper;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;

public final class GregorianCalendarParser {
    private static final TimeZone defaultTimeZone = TimeZone.getDefault();

    private static int getIntrinsicValue(char c, int pos) throws ProtocolException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new ProtocolException("Expected a digit", pos);
    }

    public static Calendar parseDateString(MonetResultSet mrs, String toParse, ParsePosition pos, SimpleDateFormat parser, int jdbcType) {
        char[] monDate;
        int pos1;
        pos.setIndex(0);
        GregorianCalendar res = new GregorianCalendar();
        if (jdbcType == 92 || jdbcType == 93 || jdbcType == 91) {
            parser.setTimeZone(TimeZone.getTimeZone("GMT" + toParse.substring(toParse.length() - 6)));
        } else {
            parser.setTimeZone(defaultTimeZone);
        }
        Date aux = parser.parse(toParse, pos);
        if (aux == null) {
            int epos = pos.getErrorIndex();
            if (epos == -1) {
                mrs.addWarning("parsing '" + toParse + "' failed", "01M10");
            } else if (epos < toParse.length()) {
                mrs.addWarning("parsing failed, found: '" + toParse.charAt(epos) + "' in: \"" + toParse + "\" at pos: " + pos.getErrorIndex(), "01M10");
            } else {
                mrs.addWarning("parsing failed, expected more data after '" + toParse + "'", "01M10");
            }
            res.clear();
        } else {
            res.setTime(aux);
        }
        if (jdbcType != 91 && (pos1 = pos.getIndex()) < (monDate = toParse.toCharArray()).length && monDate[pos1] == '.') {
            ++pos1;
            try {
                int nanos = GregorianCalendarParser.getIntrinsicValue(monDate[pos1], pos1++);
                int ctr = 1;
                while (pos1 < monDate.length && monDate[pos1] >= '0' && monDate[pos1] <= '9') {
                    if (ctr < 9) {
                        nanos *= 10;
                        nanos += GregorianCalendarParser.getIntrinsicValue(monDate[pos1], pos1);
                    }
                    if (ctr == 2) {
                        res.set(14, nanos);
                    }
                    ++pos1;
                    ++ctr;
                }
                while (ctr++ < 9) {
                    nanos *= 10;
                }
            }
            catch (ProtocolException e) {
                mrs.addWarning(e.getMessage() + " found: '" + monDate[e.getErrorOffset()] + "' in: \"" + toParse + "\" at pos: " + e.getErrorOffset(), "01M10");
                res.clear();
            }
        }
        return res;
    }

    public static Calendar parseDate(String toParse, ParsePosition pos, SimpleDateFormat parser) throws ProtocolException {
        pos.setIndex(0);
        GregorianCalendar res = new GregorianCalendar();
        Date util = parser.parse(toParse, pos);
        if (util == null) {
            res.clear();
        } else {
            res.setTime(util);
        }
        return res;
    }

    public static Calendar parseTime(String toParse, ParsePosition pos, SimpleDateFormat parser, boolean hasTimeZone) throws ProtocolException {
        pos.setIndex(0);
        if (hasTimeZone) {
            parser.setTimeZone(TimeZone.getTimeZone("GMT" + toParse.substring(toParse.length() - 6)));
        } else {
            parser.setTimeZone(defaultTimeZone);
        }
        GregorianCalendar res = new GregorianCalendar();
        Date util = parser.parse(toParse, pos);
        if (util == null) {
            res.clear();
        } else {
            res.setTime(util);
        }
        return res;
    }

    public static TimestampHelper parseTimestamp(String toParse, ParsePosition pos, SimpleDateFormat parser, boolean hasTimeZone) throws ProtocolException {
        pos.setIndex(0);
        if (hasTimeZone) {
            parser.setTimeZone(TimeZone.getTimeZone("GMT" + toParse.substring(toParse.length() - 6)));
        } else {
            parser.setTimeZone(defaultTimeZone);
        }
        GregorianCalendar res = new GregorianCalendar();
        Date util = parser.parse(toParse, pos);
        if (util != null) {
            res.setTime(util);
        } else {
            res.clear();
        }
        int pos1 = pos.getIndex();
        int nanos = 0;
        if (pos1 < toParse.length() && toParse.charAt(pos1) == '.') {
            nanos = GregorianCalendarParser.getIntrinsicValue(toParse.charAt(++pos1), pos1++);
            int ctr = 1;
            while (pos1 < toParse.length() && toParse.charAt(pos1) >= '0' && toParse.charAt(pos1) <= '9') {
                if (ctr < 9) {
                    nanos *= 10;
                    nanos += GregorianCalendarParser.getIntrinsicValue(toParse.charAt(pos1), pos1);
                }
                if (ctr == 2) {
                    res.set(14, nanos);
                }
                ++pos1;
                ++ctr;
            }
            while (ctr++ < 9) {
                nanos *= 10;
            }
        }
        return new TimestampHelper(res, nanos);
    }
}

