/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection.helpers;

import java.nio.CharBuffer;

public final class BufferReallocator {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private static int getNewCapacity(CharBuffer buffer) {
        int minCapacity = buffer.capacity() << 1;
        int newCapacity = (buffer.capacity() << 1) + 2;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity <= 0 || 0x7FFFFFF7 - newCapacity < 0) {
            if (Integer.MAX_VALUE - minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? minCapacity : 0x7FFFFFF7;
        }
        return newCapacity;
    }

    public static CharBuffer reallocateBuffer(CharBuffer buffer) {
        int newCapacity = BufferReallocator.getNewCapacity(buffer);
        CharBuffer newBuffer = CharBuffer.wrap(new char[newCapacity]);
        buffer.flip();
        newBuffer.put(buffer.array());
        return newBuffer;
    }

    public static CharBuffer ensureCapacity(CharBuffer buffer, int capacityThreshold) {
        if (capacityThreshold > buffer.capacity()) {
            buffer = CharBuffer.wrap(new char[capacityThreshold]);
        }
        return buffer;
    }
}

