/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.jdbc.MonetVirtualResultSet;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.mcl.responses.IResponse;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;
import nl.cwi.monetdb.mcl.responses.SchemaResponse;
import nl.cwi.monetdb.mcl.responses.UpdateResponse;

public class MonetStatement
extends MonetWrapper
implements Statement,
AutoCloseable {
    private MonetConnection connection;
    private MonetConnection.ResponseList lastResponseList;
    IResponse header;
    private SQLWarning warnings;
    protected boolean closed;
    boolean poolable;
    private boolean closeOnCompletion = false;
    private int fetchSize = 0;
    private int maxRows = 0;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private List<String> batch = new ArrayList<String>();
    private Lock batchLock = new ReentrantLock();

    MonetStatement(MonetConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws IllegalArgumentException {
        if (connection == null) {
            throw new IllegalArgumentException("No Connection given!");
        }
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        if (resultSetConcurrency != 1007) {
            this.addWarning("No concurrency mode other then read only is supported, continuing with concurrency level READ_ONLY", "01M13");
            this.resultSetConcurrency = 1007;
        }
        if (resultSetType == 1005) {
            this.addWarning("Change sensitive scrolling ResultSet objects are not supported, continuing with a change non-sensitive scrollable cursor.", "01M14");
            this.resultSetType = 1004;
        }
        if (resultSetHoldability != 1) {
            this.addWarning("Close cursors at commit not supported, continuing with holdability to hold open cursors over commit.", "01M15");
        }
        this.closed = false;
        this.poolable = false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() {
        this.batch.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.batchLock.lock();
        try {
            if (this.batch.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int[] counts = new int[this.batch.size()];
            BatchUpdateException e = new BatchUpdateException("Error(s) occurred while executing the batch, see next SQLExceptions for details", "22000", counts);
            MonetConnection con = (MonetConnection)this.getConnection();
            boolean error = con.executeNextQueryBatch(this, this.batch, counts, e);
            if (error) {
                throw e;
            }
            int[] nArray = counts;
            return nArray;
        }
        finally {
            this.batchLock.unlock();
        }
    }

    public boolean internalBatch(String batch, int[] counts, int offset, int max, BatchUpdateException e) throws BatchUpdateException {
        try {
            boolean type = this.internalExecute(batch);
            int count = -1;
            if (!type) {
                count = this.getUpdateCount();
            }
            do {
                if (offset >= max) {
                    throw new SQLException("Overflow: don't use multi statements when batching (" + max + ")", "M1M16");
                }
                if (type) {
                    e.setNextException(new SQLException("Batch query produced a ResultSet! Ignoring and setting update count to value -3", "M1M17"));
                    counts[offset] = -3;
                } else if (count >= 0) {
                    counts[offset] = count;
                }
                ++offset;
            } while ((type = this.getMoreResults()) || (count = this.getUpdateCount()) != -1);
        }
        catch (SQLException ex) {
            e.setNextException(ex);
            while (offset < max) {
                counts[offset] = -3;
                ++offset;
            }
            return true;
        }
        return false;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("Query cancelling is currently not supported by the driver.", "0A000");
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        this.closed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.internalExecute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.internalExecute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported", "01M18");
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported", "01M18");
        return this.execute(sql, 1);
    }

    private boolean internalExecute(String sql) throws SQLException {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        MonetConnection monetConnection = this.connection;
        Objects.requireNonNull(monetConnection);
        this.lastResponseList = new MonetConnection.ResponseList(monetConnection, this.fetchSize, this.maxRows, this.resultSetType, this.resultSetConcurrency);
        this.lastResponseList.processQuery(sql);
        return this.getMoreResults();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        if (this.execute(sql)) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeUpdate(sql, 1);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String[] columns = new String[1];
        String[] types = new String[1];
        int[] jdbcTypes = new int[1];
        columns[0] = "GENERATED_KEY";
        types[0] = "BIGINT";
        jdbcTypes[0] = MonetDriver.getJavaType(types[0]);
        Object[] results = new Object[]{new long[1]};
        ((long[])results[0])[0] = this.header instanceof UpdateResponse ? (long)((UpdateResponse)this.header).getLastid() : -1L;
        try {
            return new MonetVirtualResultSet((Statement)this, columns, types, jdbcTypes, results);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.lastResponseList == null) {
            this.header = null;
            return false;
        }
        if (current == 1) {
            this.lastResponseList.closeCurrentResponse();
        } else if (current == 3) {
            this.lastResponseList.closeCurOldResponses();
        }
        this.header = this.lastResponseList.getNextResponse();
        return this.header instanceof ResultSetResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.connection.createStatement();
            rs = st.executeQuery("SELECT \"querytimeout\" FROM \"sys\".\"sessions\"() WHERE \"active\"");
            if (rs != null && rs.next()) {
                long timeout = rs.getLong(1);
                int n = timeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout;
                return n;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.header instanceof ResultSetResponse ? new MonetResultSet(this, (ResultSetResponse)this.header) : null;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int ret = -1;
        if (this.header instanceof UpdateResponse) {
            ret = ((UpdateResponse)this.header).getCount();
        } else if (this.header instanceof SchemaResponse) {
            ret = ((SchemaResponse)this.header).getState();
        }
        return ret;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.addWarning("setCursorName: positioned updates/deletes not supported", "01M21");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            this.addWarning("setEscapeProcessing: JDBC escape syntax is not supported by this driver", "01M22");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Illegal direction: " + direction, "M1M05");
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            throw new SQLException("Illegal fetch size value: " + rows, "M1M05");
        }
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Illegal max value: " + max, "M1M05");
        }
        if (max > 0) {
            this.addWarning("setMaxFieldSize: field size limitation not supported", "01M23");
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Illegal max value: " + max, "M1M05");
        }
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Illegal timeout value: " + seconds, "M1M05");
        }
        try (Statement st = null;){
            st = this.connection.createStatement();
            st.execute("CALL \"sys\".\"settimeout\"(" + seconds + ")");
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        return this.closeOnCompletion;
    }

    private void addWarning(String reason, String sqlstate) {
        SQLWarning warng = new SQLWarning(reason, sqlstate);
        if (this.warnings == null) {
            this.warnings = warng;
        } else {
            this.warnings.setNextWarning(warng);
        }
    }

    void closeIfCompletion() {
        if (!this.closeOnCompletion || this.lastResponseList == null) {
            return;
        }
        if (!this.lastResponseList.hasUnclosedResponses()) {
            this.close();
        }
    }
}

