/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol.oldmapi;

import nl.cwi.monetdb.mcl.protocol.ProtocolException;

final class OldMapiTupleLineParserHelper {
    private static final char[] TRUE_CONSTANT = new char[]{'t', 'r', 'u', 'e'};

    private OldMapiTupleLineParserHelper() {
    }

    static int charIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    static byte charArrayToBoolean(char[] data, int start) {
        return OldMapiTupleLineParserHelper.charIndexOf(data, 0, data.length, TRUE_CONSTANT, 0, 4, start) == start ? (byte)1 : 0;
    }

    static byte charArrayToByte(char[] data, int start, int count) throws ProtocolException {
        char chr;
        byte tmp = 0;
        int limit = start + count;
        boolean positive = true;
        if ((chr = data[start++]) >= '0' && chr <= '9') {
            tmp = (byte)(chr - 48);
        } else if (chr == '-') {
            positive = false;
        } else {
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        while (start < limit && (chr = data[start++]) != ' ') {
            tmp = (byte)(tmp * 10);
            if (chr >= '0' && chr <= '9') {
                tmp = (byte)(tmp + (chr - 48));
                continue;
            }
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        return positive ? tmp : (byte)(-tmp);
    }

    static short charArrayToShort(char[] data, int start, int count) throws ProtocolException {
        char chr;
        short tmp = 0;
        int limit = start + count;
        boolean positive = true;
        if ((chr = data[start++]) >= '0' && chr <= '9') {
            tmp = (short)(chr - 48);
        } else if (chr == '-') {
            positive = false;
        } else {
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        while (start < limit && (chr = data[start++]) != ' ') {
            tmp = (short)(tmp * 10);
            if (chr >= '0' && chr <= '9') {
                tmp = (short)(tmp + (chr - 48));
                continue;
            }
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        return positive ? tmp : (short)(-tmp);
    }

    static int charArrayToInt(char[] data, int start, int count) throws ProtocolException {
        char chr;
        int tmp = 0;
        int limit = start + count;
        boolean positive = true;
        if ((chr = data[start++]) >= '0' && chr <= '9') {
            tmp = chr - 48;
        } else if (chr == '-') {
            positive = false;
        } else {
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        while (start < limit && (chr = data[start++]) != ' ') {
            if (chr == '.') continue;
            tmp *= 10;
            if (chr >= '0' && chr <= '9') {
                tmp += chr - 48;
                continue;
            }
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        return positive ? tmp : -tmp;
    }

    static long charArrayToLong(char[] data, int start, int count) throws ProtocolException {
        char chr;
        long tmp = 0L;
        int limit = start + count;
        boolean positive = true;
        if ((chr = data[start++]) >= '0' && chr <= '9') {
            tmp = chr - 48;
        } else if (chr == '-') {
            positive = false;
        } else {
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        while (start < limit && (chr = data[start++]) != ' ') {
            if (chr == '.') continue;
            tmp *= 10L;
            if (chr >= '0' && chr <= '9') {
                tmp += (long)(chr - 48);
                continue;
            }
            throw new ProtocolException("Expected a digit at the position " + (start - 1));
        }
        return positive ? tmp : -tmp;
    }
}

