/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection.mapi;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.mcl.connection.MCLException;
import nl.cwi.monetdb.mcl.connection.helpers.ChannelSecurity;
import nl.cwi.monetdb.mcl.connection.mapi.MapiLanguage;
import nl.cwi.monetdb.mcl.connection.mapi.OldMapiSocket;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiProtocol;

public class MapiConnection
extends MonetConnection {
    static final char PROMPT_CHAR = '.';
    private static final int DEF_FETCHSIZE = 250;
    private final String hostname;
    private final int port;
    private String database;
    private int soTimeout = 0;
    private boolean followRedirects = true;
    private int ttl = 10;
    private int version;
    private ByteOrder serverEndianness;

    public MapiConnection(Properties props, String hash, String language, boolean blobIsBinary, boolean clobIsLongChar, String hostname, int port, String database) {
        super(props, hash, MapiLanguage.getLanguageFromString(language), blobIsBinary, clobIsLongChar);
        this.hostname = hostname;
        this.port = port;
        this.database = database;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        if (this.protocol != null) {
            this.soTimeout = ((OldMapiProtocol)this.protocol).getSocket().getSoTimeout();
        }
        return this.soTimeout;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout can't be negative");
        }
        if (this.protocol != null) {
            ((OldMapiProtocol)this.protocol).getSocket().setSoTimeout(timeout);
        }
        this.soTimeout = timeout;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getVersion() {
        return this.version;
    }

    public ByteOrder getServerEndianness() {
        return this.serverEndianness;
    }

    @Override
    public int getBlockSize() {
        return ((OldMapiProtocol)this.protocol).getSocket().getBlockSize();
    }

    @Override
    public int getDefFetchsize() {
        return 250;
    }

    @Override
    public int initialStringBuilderSize() {
        return this.getBlockSize();
    }

    @Override
    public synchronized void closeUnderlyingConnection() throws IOException {
        ((OldMapiProtocol)this.protocol).getSocket().close();
    }

    @Override
    public String getJDBCURL() {
        String res = "jdbc:monetdb://" + this.hostname + ":" + this.port + "/" + this.database;
        if (this.getLanguage() == MapiLanguage.LANG_MAL) {
            res = res + "?language=mal";
        }
        return res;
    }

    @Override
    public void sendControlCommand(int commandID, int data) throws SQLException {
        String command = null;
        switch (commandID) {
            case 1: {
                command = "auto_commit " + (data == 1 ? "1" : "0");
                break;
            }
            case 2: {
                command = "reply_size " + data;
                break;
            }
            case 3: {
                command = "release " + data;
                break;
            }
            case 4: {
                command = "close " + data;
            }
        }
        try {
            this.protocol.writeNextQuery(this.language.getCommandTemplateIndex(0), command, this.language.getCommandTemplateIndex(1));
            this.protocol.waitUntilPrompt();
            int csrh = this.protocol.getCurrentServerResponse();
            if (csrh == 1) {
                String error = this.protocol.getRemainingStringLine(0);
                throw new SQLException(error.substring(6), error.substring(0, 5));
            }
        }
        catch (SocketTimeoutException e) {
            this.close();
            throw new SQLNonTransientConnectionException("connection timed out", "08M33");
        }
        catch (IOException e) {
            throw new SQLNonTransientConnectionException(e.getMessage(), "08000");
        }
    }

    @Override
    public List<String> connect(String user, String pass) throws IOException, ProtocolException, MCLException {
        List<String> res = this.connect(this.hostname, this.port, user, pass, true);
        this.setSoTimeout(this.getSoTimeout());
        return res;
    }

    private List<String> connect(String host, int port, String user, String pass, boolean makeConnection) throws IOException, ProtocolException, MCLException {
        int next;
        if (this.ttl-- <= 0) {
            throw new MCLException("Maximum number of redirects reached, aborting connection attempt. Sorry.");
        }
        if (makeConnection) {
            this.protocol = new OldMapiProtocol(new OldMapiSocket(this.hostname, this.port, this));
            ((OldMapiProtocol)this.protocol).getSocket().setTcpNoDelay(true);
            ((OldMapiProtocol)this.protocol).getSocket().setSoTimeout(this.soTimeout);
        }
        this.protocol.fetchNextResponseData();
        String nextLine = this.protocol.getRemainingStringLine(0);
        this.protocol.waitUntilPrompt();
        String test = this.getChallengeResponse(nextLine, user, pass, this.language.getRepresentation(), this.database, this.hash);
        this.protocol.writeNextQuery("", test, "");
        ArrayList<String> redirects = new ArrayList<String>();
        ArrayList<String> warns = new ArrayList<String>();
        String err = "";
        do {
            this.protocol.fetchNextResponseData();
            next = this.protocol.getCurrentServerResponse();
            switch (next) {
                case 1: {
                    err = err + "\n" + this.protocol.getRemainingStringLine(7);
                    break;
                }
                case 8: {
                    warns.add(this.protocol.getRemainingStringLine(1));
                    break;
                }
                case 7: {
                    redirects.add(this.protocol.getRemainingStringLine(1));
                }
            }
        } while (next != 4);
        if (!err.equals("")) {
            this.close();
            throw new MCLException(err.trim());
        }
        if (!redirects.isEmpty()) {
            if (this.followRedirects) {
                URI u;
                String suri = (String)redirects.get(0);
                if (!suri.startsWith("mapi:")) {
                    throw new MCLException("unsupported redirect: " + suri);
                }
                try {
                    u = new URI(suri.substring(5));
                }
                catch (URISyntaxException e) {
                    throw new ProtocolException(e.toString());
                }
                String tmp = u.getQuery();
                if (tmp != null) {
                    String[] args;
                    block28: for (String arg : args = tmp.split("&")) {
                        int pos = arg.indexOf("=");
                        if (pos > 0) {
                            switch (tmp = arg.substring(0, pos)) {
                                case "database": {
                                    tmp = arg.substring(pos + 1);
                                    if (tmp.equals(this.database)) continue block28;
                                    warns.add("redirect points to different database: " + tmp);
                                    this.database = tmp;
                                    break;
                                }
                                case "language": {
                                    tmp = arg.substring(pos + 1);
                                    warns.add("redirect specifies use of different language: " + tmp);
                                    this.language = MapiLanguage.getLanguageFromString(tmp);
                                    break;
                                }
                                case "user": {
                                    tmp = arg.substring(pos + 1);
                                    if (tmp.equals(user)) continue block28;
                                    warns.add("ignoring different username '" + tmp + "' set by redirect, what are the security implications?");
                                    break;
                                }
                                case "password": {
                                    warns.add("ignoring different password set by redirect, what are the security implications?");
                                    break;
                                }
                                default: {
                                    warns.add("ignoring unknown argument '" + tmp + "' from redirect");
                                    break;
                                }
                            }
                            continue;
                        }
                        warns.add("ignoring illegal argument from redirect: " + arg);
                    }
                }
                switch (u.getScheme()) {
                    case "monetdb": {
                        tmp = u.getPath();
                        if (tmp != null && tmp.length() != 0 && !(tmp = tmp.substring(1).trim()).isEmpty() && !tmp.equals(this.database)) {
                            warns.add("redirect points to different database: " + tmp);
                            this.database = tmp;
                        }
                        int p = u.getPort();
                        warns.addAll(this.connect(u.getHost(), p == -1 ? port : p, user, pass, true));
                        warns.add("Redirect by " + host + ":" + port + " to " + suri);
                        break;
                    }
                    case "merovingian": {
                        warns.addAll(this.connect(host, port, user, pass, false));
                        break;
                    }
                    default: {
                        throw new MCLException("unsupported scheme in redirect: " + suri);
                    }
                }
            } else {
                StringBuilder msg = new StringBuilder("The server sent a redirect for this connection:");
                for (String it : redirects) {
                    msg.append(" [").append(it).append("]");
                }
                throw new MCLException(msg.toString());
            }
        }
        return warns;
    }

    private String getChallengeResponse(String chalstr, String username, String password, String language, String database, String hash) throws ProtocolException, MCLException, IOException {
        String[] chaltok = chalstr.split(":");
        if (chaltok.length <= 4) {
            throw new ProtocolException("Server challenge string unusable! Challenge contains too few tokens: " + chalstr);
        }
        String challenge = chaltok[0];
        String servert = chaltok[1];
        try {
            this.version = Integer.parseInt(chaltok[2].trim());
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Protocol version unparseable: " + chaltok[2]);
        }
        switch (chaltok[4]) {
            case "BIG": {
                this.serverEndianness = ByteOrder.BIG_ENDIAN;
                break;
            }
            case "LIT": {
                this.serverEndianness = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw new ProtocolException("Invalid byte-order: " + chaltok[4]);
            }
        }
        ((OldMapiProtocol)this.protocol).getSocket().setSocketChannelEndianness(this.serverEndianness);
        switch (this.version) {
            case 9: {
                String pwhash;
                String algo;
                switch (chaltok[5]) {
                    case "SHA512": {
                        algo = "SHA-512";
                        break;
                    }
                    case "SHA384": {
                        algo = "SHA-384";
                        break;
                    }
                    case "SHA256": {
                        algo = "SHA-256";
                        break;
                    }
                    case "SHA1": {
                        algo = "SHA-1";
                        break;
                    }
                    case "MD5": {
                        algo = "MD5";
                        break;
                    }
                    default: {
                        throw new MCLException("Unsupported password hash: " + chaltok[5]);
                    }
                }
                password = ChannelSecurity.digestStrings(algo, new byte[][]{password.getBytes("UTF-8")});
                String hashes = hash == null ? chaltok[3] : hash;
                HashSet<String> hashesSet = new HashSet<String>(Arrays.asList(hashes.toUpperCase().split("[, ]")));
                if (servert.equals("merovingian") && !language.equals("control")) {
                    username = "merovingian";
                    password = "merovingian";
                }
                if (hashesSet.contains("SHA512")) {
                    algo = "SHA-512";
                    pwhash = "{SHA512}";
                } else if (hashesSet.contains("SHA384")) {
                    algo = "SHA-384";
                    pwhash = "{SHA384}";
                } else if (hashesSet.contains("SHA256")) {
                    algo = "SHA-256";
                    pwhash = "{SHA256}";
                } else if (hashesSet.contains("SHA1")) {
                    algo = "SHA-1";
                    pwhash = "{SHA1}";
                } else if (hashesSet.contains("MD5")) {
                    algo = "MD5";
                    pwhash = "{MD5}";
                } else {
                    throw new MCLException("No supported password hashes in " + hashes);
                }
                pwhash = pwhash + ChannelSecurity.digestStrings(algo, password.getBytes("UTF-8"), challenge.getBytes("UTF-8"));
                String response = "BIG:";
                response = response + username + ":" + pwhash + ":" + language;
                response = response + ":" + (database == null ? "" : database) + ":";
                this.conn_props.setProperty("hash", hashes);
                this.conn_props.setProperty("language", language);
                this.conn_props.setProperty("database", database);
                return response;
            }
        }
        throw new MCLException("Unsupported protocol version: " + this.version);
    }
}

