/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;

public class SenderThread
extends Thread {
    private static final int WAIT = 1;
    private static final int QUERY = 2;
    private static final int SHUTDOWN = 3;
    private String[] templ;
    private String query;
    private AbstractProtocol protocol;
    private String error;
    private int state = 1;
    private final Lock sendLock = new ReentrantLock();
    private final Condition queryAvailable = this.sendLock.newCondition();
    private final Condition waiting = this.sendLock.newCondition();

    public SenderThread(AbstractProtocol out) {
        super("SendThread");
        this.setDaemon(true);
        this.protocol = out;
        this.start();
    }

    @Override
    public void run() {
        this.sendLock.lock();
        try {
            while (true) {
                if (this.state == 1) {
                    try {
                        this.queryAvailable.await();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.state == 3) {
                    break;
                }
                try {
                    this.protocol.writeNextQuery(this.templ[0] == null ? "" : this.templ[0], this.query, this.templ[1] == null ? "" : this.templ[1]);
                }
                catch (IOException e) {
                    this.error = e.getMessage();
                }
                this.state = 1;
                this.waiting.signal();
            }
        }
        finally {
            this.sendLock.unlock();
        }
    }

    public void runQuery(String[] templ, String query) throws SQLException {
        this.sendLock.lock();
        try {
            if (this.state != 1) {
                throw new SQLException("Sender Thread already in use or shutting down!", "M0M03");
            }
            this.templ = templ;
            this.query = query;
            this.state = 2;
            this.queryAvailable.signal();
        }
        finally {
            this.sendLock.unlock();
        }
    }

    public String getErrors() {
        this.sendLock.lock();
        try {
            while (this.state == 2) {
                try {
                    this.waiting.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.state == 3) {
                this.error = "SendThread is shutting down";
            }
        }
        finally {
            this.sendLock.unlock();
        }
        return this.error;
    }

    public void shutdown() {
        this.sendLock.lock();
        this.state = 3;
        this.sendLock.unlock();
        this.interrupt();
    }
}

