/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class MonetClob
implements Clob,
Serializable,
Comparable<MonetClob> {
    private final StringBuilder buffer;

    public MonetClob(String in) {
        this.buffer = new StringBuilder(in);
    }

    public MonetClob(char[] toParse, int startPosition, int count) {
        this.buffer = new StringBuilder(new String(toParse, startPosition, count));
    }

    @Override
    public void free() {
        this.buffer.setLength(0);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return new ByteArrayInputStream(this.buffer.toString().getBytes());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return new StringReader(this.buffer.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return new StringReader(this.buffer.substring((int)(pos - 1L), (int)(pos - 1L + length)));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        try {
            return this.buffer.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public long length() throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return this.buffer.length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return this.buffer.indexOf(searchstr, (int)(start - 1L));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        throw new SQLException("Operation setAsciiStream(long pos) currently not supported", "0A000");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        throw new SQLException("Operation setCharacterStream(long pos) currently not supported", "0A000");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 1, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        int buflen = this.buffer.length();
        int retlen = Math.min(buflen, (int)(pos - 1L + (long)len));
        if (retlen > 0) {
            this.buffer.replace((int)(pos - 1L), (int)(pos + (long)retlen), str.substring(offset - 1, offset + len));
            return retlen;
        }
        return 0;
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.buffer.length() == 0) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        this.buffer.setLength((int)len);
    }

    public String toString() {
        if (this.buffer.length() == 0) {
            return "<a freed MonetClob instance>";
        }
        return this.buffer.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof MonetClob && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.buffer.toString().hashCode();
    }

    @Override
    public int compareTo(MonetClob o) {
        return this.toString().compareTo(o.toString());
    }
}

