/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.CharBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;

public class MonetPreparedStatement
extends MonetStatement
implements PreparedStatement {
    private final MonetConnection connection;
    private final String[] monetdbType;
    private final int[] javaType;
    private final int[] digits;
    private final int[] scale;
    private final String[] schema;
    private final String[] table;
    private final String[] column;
    private final int id;
    private final int size;
    private final int rscolcnt;
    private final String[] values;
    private final SimpleDateFormat mTimestampZ;
    private final SimpleDateFormat mTimestamp;
    private final SimpleDateFormat mTimeZ;
    private final SimpleDateFormat mTime;
    private final SimpleDateFormat mDate;
    private static final String HEXES = "0123456789ABCDEF";

    MonetPreparedStatement(MonetConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String prepareQuery) throws SQLException, IllegalArgumentException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (!super.execute("PREPARE " + prepareQuery)) {
            throw new SQLException("Unexpected server response", "M0M10");
        }
        this.id = ((ResultSetResponse)this.header).getId();
        this.size = ((ResultSetResponse)this.header).getTuplecount();
        this.rscolcnt = ((ResultSetResponse)this.header).getColumncount();
        this.monetdbType = new String[this.size];
        this.javaType = new int[this.size];
        this.digits = new int[this.size];
        this.scale = new int[this.size];
        this.schema = new String[this.size];
        this.table = new String[this.size];
        this.column = new String[this.size];
        this.values = new String[this.size];
        this.connection = connection;
        ResultSet rs = super.getResultSet();
        int i = 0;
        while (rs.next()) {
            this.monetdbType[i] = rs.getString("type");
            this.javaType[i] = MonetDriver.getJavaType(this.monetdbType[i]);
            this.digits[i] = rs.getInt("digits");
            this.scale[i] = rs.getInt("scale");
            if (this.rscolcnt != 3) {
                this.schema[i] = rs.getString("schema");
                this.table[i] = rs.getString("table");
                this.column[i] = rs.getString("column");
            }
            ++i;
        }
        rs.close();
        this.poolable = true;
        this.mTimestampZ = connection.getProtocol().getMonetTimestampTz();
        this.mTimestamp = connection.getProtocol().getMonetTimestamp();
        this.mTimeZ = connection.getProtocol().getMonetTimeTz();
        this.mTime = connection.getProtocol().getMonetTime();
        this.mDate = connection.getProtocol().getMonetDate();
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch(this.transform());
    }

    @Override
    public void addBatch(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public void clearParameters() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.transform());
    }

    @Override
    public boolean execute(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public ResultSet executeQuery(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    private int getColumnIdx(int colnr) throws SQLException {
        int curcol = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] == null || ++curcol != colnr) continue;
            return i;
        }
        throw new SQLException("No such column with index: " + colnr, "M1M05");
    }

    private int getParamIdx(int paramnr) throws SQLException {
        int curparam = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] != null || ++curparam != paramnr) continue;
            return i;
        }
        throw new SQLException("No such parameter with index: " + paramnr, "M1M05");
    }

    @Override
    public ResultSetMetaData getMetaData() {
        if (this.rscolcnt == 3) {
            return null;
        }
        return new rsmdw(){

            @Override
            public int getColumnCount() {
                int cnt = 0;
                for (int i = 0; i < MonetPreparedStatement.this.size; ++i) {
                    if (MonetPreparedStatement.this.column[i] == null) continue;
                    ++cnt;
                }
                return cnt;
            }

            @Override
            public boolean isAutoIncrement(int column) throws SQLException {
                return false;
            }

            @Override
            public boolean isCaseSensitive(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int column) {
                return true;
            }

            @Override
            public boolean isCurrency(int column) {
                return false;
            }

            @Override
            public boolean isSigned(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.digits[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getSchemaName(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.schema[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getTableName(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.table[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int getPrecision(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.digits[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int getScale(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.scale[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int isNullable(int column) throws SQLException {
                return 2;
            }

            @Override
            public String getCatalogName(int column) throws SQLException {
                return null;
            }

            @Override
            public boolean isReadOnly(int column) {
                return true;
            }

            @Override
            public boolean isWritable(int column) {
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int column) {
                return false;
            }

            @Override
            public String getColumnClassName(int column) throws SQLException {
                return MonetResultSet.getClassForType(this.getColumnType(column)).getName();
            }

            @Override
            public String getColumnLabel(int column) throws SQLException {
                return this.getColumnName(column);
            }

            @Override
            public String getColumnName(int colnr) throws SQLException {
                try {
                    return MonetPreparedStatement.this.column[MonetPreparedStatement.this.getColumnIdx(colnr)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(colnr);
                }
            }

            @Override
            public int getColumnType(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.javaType[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getColumnTypeName(int column) throws SQLException {
                try {
                    return MonetPreparedStatement.this.monetdbType[MonetPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }
        };
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new pmdw(){

            @Override
            public int getParameterCount() throws SQLException {
                int cnt = 0;
                for (int i = 0; i < MonetPreparedStatement.this.size; ++i) {
                    if (MonetPreparedStatement.this.column[i] != null) continue;
                    ++cnt;
                }
                return cnt;
            }

            @Override
            public int isNullable(int param) throws SQLException {
                return 2;
            }

            @Override
            public boolean isSigned(int param) throws SQLException {
                switch (this.getParameterType(param)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getPrecision(int param) throws SQLException {
                try {
                    return MonetPreparedStatement.this.digits[MonetPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(param);
                }
            }

            @Override
            public int getScale(int param) throws SQLException {
                try {
                    return MonetPreparedStatement.this.scale[MonetPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(param);
                }
            }

            @Override
            public int getParameterType(int param) throws SQLException {
                try {
                    return MonetPreparedStatement.this.javaType[MonetPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(param);
                }
            }

            @Override
            public String getParameterTypeName(int param) throws SQLException {
                try {
                    return MonetPreparedStatement.this.monetdbType[MonetPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(param);
                }
            }

            @Override
            public String getParameterClassName(int param) throws SQLException {
                String typeName = this.getParameterTypeName(param);
                Map<String, Class<?>> map = MonetPreparedStatement.this.getConnection().getTypeMap();
                Class<?> c = map.containsKey(typeName) ? map.get(typeName) : MonetResultSet.getClassForType(this.getParameterType(param));
                return c.getName();
            }

            @Override
            public int getParameterMode(int param) throws SQLException {
                return 0;
            }
        };
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setArray");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBigDecimal(int idx, BigDecimal x) throws SQLException {
        int i = this.getParamIdx(idx);
        if ((x = x.setScale(this.scale[i], RoundingMode.HALF_UP)).precision() > this.digits[i]) {
            throw new SQLDataException("DECIMAL value exceeds allowed digits/scale: " + x.toPlainString() + " (" + this.digits[i] + "/" + this.scale[i] + ")", "22003");
        }
        String xStr = x.toPlainString();
        int dot = xStr.indexOf(46);
        if (dot >= 0) {
            xStr = xStr.substring(0, Math.min(xStr.length(), dot + 1 + this.scale[i]));
        }
        while (xStr.startsWith("0") && xStr.length() > 1) {
            xStr = xStr.substring(1);
        }
        this.setValue(idx, xStr);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        byte[] arr = new byte[8192];
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            int numChars;
            while ((numChars = stream.read(arr, 0, arr.length)) > 0) {
                buf.write(arr, 0, numChars);
            }
            this.setBytes(parameterIndex, buf.toByteArray());
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        this.setBytes(parameterIndex, x.getBytes(0L, (int)x.length()));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        try {
            byte[] arr = new byte[(int)length];
            ByteArrayOutputStream buf = new ByteArrayOutputStream((int)length);
            int numChars = stream.read(arr, 0, (int)length);
            buf.write(arr, 0, numChars);
            this.setBytes(parameterIndex, buf.toByteArray());
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        StringBuilder hex = new StringBuilder(x.length * 2);
        for (byte aX : x) {
            hex.append(HEXES.charAt((aX & 0xF0) >> 4)).append(HEXES.charAt(aX & 0xF));
        }
        this.setValue(parameterIndex, "blob '" + hex.toString() + "'");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        CharBuffer tmp = CharBuffer.allocate(length);
        try {
            reader.read(tmp);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), "M1M25");
        }
        this.setString(parameterIndex, tmp.toString());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, 0);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        if (x == null) {
            this.setNull(i, -1);
            return;
        }
        this.setString(i, x.getSubString(1L, (int)x.length()));
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(i, -1);
            return;
        }
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder(65536);
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
            this.setString(i, buf.toString());
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setClob(int i, Reader reader, long length) throws SQLException {
        if (reader == null || length < 0L) {
            this.setNull(i, -1);
            return;
        }
        CharBuffer buf = CharBuffer.allocate((int)length);
        try {
            reader.read(buf);
        }
        catch (IOException e) {
            throw new SQLException("failed to read from stream: " + e.getMessage(), "M1M25");
        }
        buf.rewind();
        this.setString(i, buf.toString());
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        if (cal == null) {
            this.setValue(parameterIndex, "date '" + x.toString() + "'");
        } else {
            this.mDate.setTimeZone(cal.getTimeZone());
            this.setValue(parameterIndex, "date '" + this.mDate.format(x) + "'");
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setNCharacterStream(int i, Reader value) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setNCharacterStream(int i, Reader value, long length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setNClob(int i, Reader value) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNClob(int i, NClob value) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNClob(int i, Reader r, long length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNString(int i, String value) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNString");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setValue(parameterIndex, "NULL");
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void setObject(int index, Object x) throws SQLException {
        this.setObject(index, x, this.javaType[this.getParamIdx(index)]);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        block112: {
            block116: {
                block115: {
                    block114: {
                        block113: {
                            block111: {
                                if (!(x instanceof String)) break block111;
                                switch (targetSqlType) {
                                    case -6: {
                                        byte val1;
                                        try {
                                            val1 = Byte.parseByte((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val1 = 0;
                                        }
                                        this.setByte(parameterIndex, val1);
                                        break block112;
                                    }
                                    case 5: {
                                        short val2;
                                        try {
                                            val2 = Short.parseShort((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val2 = 0;
                                        }
                                        this.setShort(parameterIndex, val2);
                                        break block112;
                                    }
                                    case 4: {
                                        int val3;
                                        try {
                                            val3 = Integer.parseInt((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val3 = 0;
                                        }
                                        this.setInt(parameterIndex, val3);
                                        break block112;
                                    }
                                    case -5: {
                                        long val4;
                                        try {
                                            val4 = Long.parseLong((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val4 = 0L;
                                        }
                                        this.setLong(parameterIndex, val4);
                                        break block112;
                                    }
                                    case 7: {
                                        float val5;
                                        try {
                                            val5 = Float.parseFloat((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val5 = 0.0f;
                                        }
                                        this.setFloat(parameterIndex, val5);
                                        break block112;
                                    }
                                    case 8: {
                                        double val6;
                                        try {
                                            val6 = Double.parseDouble((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val6 = 0.0;
                                        }
                                        this.setDouble(parameterIndex, val6);
                                        break block112;
                                    }
                                    case 2: 
                                    case 3: {
                                        BigDecimal val8;
                                        try {
                                            val8 = new BigDecimal((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            try {
                                                val8 = BigDecimal.ZERO;
                                            }
                                            catch (NumberFormatException ex) {
                                                throw new SQLException("Internal error: unable to create template BigDecimal: " + ex.getMessage(), "M0M03");
                                            }
                                        }
                                        val8 = val8.setScale(scale, 4);
                                        this.setBigDecimal(parameterIndex, val8);
                                        break block112;
                                    }
                                    case 16: {
                                        this.setBoolean(parameterIndex, Boolean.valueOf((String)x));
                                        break block112;
                                    }
                                    case -1: 
                                    case 1: 
                                    case 12: {
                                        this.setString(parameterIndex, (String)x);
                                        break block112;
                                    }
                                    case -4: {
                                        this.setBytes(parameterIndex, ((String)x).getBytes());
                                        break block112;
                                    }
                                    case 2004: {
                                        this.setBlob(parameterIndex, new MonetBlob(((String)x).getBytes()));
                                        break block112;
                                    }
                                    case 2005: {
                                        this.setClob(parameterIndex, new MonetClob((String)x));
                                        break block112;
                                    }
                                    case 91: {
                                        Date val9;
                                        try {
                                            val9 = Date.valueOf((String)x);
                                        }
                                        catch (IllegalArgumentException e) {
                                            val9 = new Date(0L);
                                        }
                                        this.setDate(parameterIndex, val9);
                                        break block112;
                                    }
                                    case 92: {
                                        Time val10;
                                        try {
                                            val10 = Time.valueOf((String)x);
                                        }
                                        catch (IllegalArgumentException e) {
                                            val10 = new Time(0L);
                                        }
                                        this.setTime(parameterIndex, val10);
                                        break block112;
                                    }
                                    case 93: {
                                        Timestamp val11;
                                        try {
                                            val11 = Timestamp.valueOf((String)x);
                                        }
                                        catch (IllegalArgumentException e) {
                                            val11 = new Timestamp(0L);
                                        }
                                        this.setTimestamp(parameterIndex, val11);
                                        break block112;
                                    }
                                    case -16: 
                                    case -15: 
                                    case -9: {
                                        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject() with targetType N[VAR]CHAR");
                                    }
                                    default: {
                                        throw new SQLException("Conversion not allowed", "M1M05");
                                    }
                                }
                            }
                            if (!(x instanceof BigDecimal) && !(x instanceof Byte) && !(x instanceof Short) && !(x instanceof Integer) && !(x instanceof Long) && !(x instanceof Float) && !(x instanceof Double)) break block113;
                            Number num = (Number)x;
                            switch (targetSqlType) {
                                case -6: {
                                    this.setByte(parameterIndex, num.byteValue());
                                    break;
                                }
                                case 5: {
                                    this.setShort(parameterIndex, num.shortValue());
                                    break;
                                }
                                case 4: {
                                    this.setInt(parameterIndex, num.intValue());
                                    break;
                                }
                                case -5: {
                                    this.setLong(parameterIndex, num.longValue());
                                    break;
                                }
                                case 7: {
                                    this.setFloat(parameterIndex, num.floatValue());
                                    break;
                                }
                                case 8: {
                                    this.setDouble(parameterIndex, num.doubleValue());
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    if (x instanceof BigDecimal) {
                                        this.setBigDecimal(parameterIndex, (BigDecimal)x);
                                        break;
                                    }
                                    this.setBigDecimal(parameterIndex, new BigDecimal(num.doubleValue()));
                                    break;
                                }
                                case 16: {
                                    if (num.doubleValue() != 0.0) {
                                        this.setBoolean(parameterIndex, true);
                                        break;
                                    }
                                    this.setBoolean(parameterIndex, false);
                                    break;
                                }
                                case -1: 
                                case 1: 
                                case 12: {
                                    this.setString(parameterIndex, x.toString());
                                    break;
                                }
                                default: {
                                    throw new SQLException("Conversion not allowed", "M1M05");
                                }
                            }
                            break block112;
                        }
                        if (!(x instanceof Boolean)) break block114;
                        boolean val = (Boolean)x;
                        switch (targetSqlType) {
                            case -6: {
                                this.setByte(parameterIndex, (byte)(val ? 1 : 0));
                                break;
                            }
                            case 5: {
                                this.setShort(parameterIndex, (short)(val ? 1 : 0));
                                break;
                            }
                            case 4: {
                                this.setInt(parameterIndex, val ? 1 : 0);
                                break;
                            }
                            case -5: {
                                this.setLong(parameterIndex, val ? 1 : 0);
                                break;
                            }
                            case 7: {
                                this.setFloat(parameterIndex, (float)(val ? 1.0 : 0.0));
                                break;
                            }
                            case 8: {
                                this.setDouble(parameterIndex, val ? 1.0 : 0.0);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.setBigDecimal(parameterIndex, val ? BigDecimal.ONE : BigDecimal.ZERO);
                                break;
                            }
                            case -7: 
                            case 16: {
                                this.setBoolean(parameterIndex, val);
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                this.setString(parameterIndex, "" + val);
                                break;
                            }
                            default: {
                                throw new SQLException("Conversion not allowed", "M1M05");
                            }
                        }
                        break block112;
                    }
                    if (!(x instanceof byte[])) break block115;
                    switch (targetSqlType) {
                        case -4: {
                            this.setBytes(parameterIndex, (byte[])x);
                            break block112;
                        }
                        case 2004: {
                            this.setBlob(parameterIndex, new MonetBlob((byte[])x));
                            break block112;
                        }
                        default: {
                            throw new SQLException("Conversion not allowed", "M1M05");
                        }
                    }
                }
                if (!(x instanceof Date) && !(x instanceof Timestamp) && !(x instanceof Time) && !(x instanceof Calendar) && !(x instanceof java.util.Date)) break block116;
                switch (targetSqlType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, x.toString());
                        break block112;
                    }
                    case 91: {
                        if (x instanceof Time) {
                            throw new SQLException("Conversion not allowed", "M1M05");
                        }
                        if (x instanceof Date) {
                            this.setDate(parameterIndex, (Date)x);
                        } else if (x instanceof Timestamp) {
                            this.setDate(parameterIndex, new Date(((Timestamp)x).getTime()));
                        } else if (x instanceof java.util.Date) {
                            this.setDate(parameterIndex, new Date(((java.util.Date)x).getTime()));
                        } else {
                            this.setDate(parameterIndex, new Date(((Calendar)x).getTimeInMillis()));
                        }
                        break block112;
                    }
                    case 92: {
                        if (x instanceof Time) {
                            this.setTime(parameterIndex, (Time)x);
                        } else {
                            if (x instanceof Date) {
                                throw new SQLException("Conversion not allowed", "M1M05");
                            }
                            if (x instanceof Timestamp) {
                                this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                            } else if (x instanceof java.util.Date) {
                                this.setTime(parameterIndex, new Time(((java.util.Date)x).getTime()));
                            } else {
                                this.setTime(parameterIndex, new Time(((Calendar)x).getTimeInMillis()));
                            }
                        }
                        break block112;
                    }
                    case 93: {
                        if (x instanceof Time) {
                            throw new SQLException("Conversion not allowed", "M1M05");
                        }
                        if (x instanceof Date) {
                            this.setTimestamp(parameterIndex, new Timestamp(((Date)x).getTime()));
                        } else if (x instanceof Timestamp) {
                            this.setTimestamp(parameterIndex, (Timestamp)x);
                        } else if (x instanceof java.util.Date) {
                            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
                        } else {
                            this.setTimestamp(parameterIndex, new Timestamp(((Calendar)x).getTimeInMillis()));
                        }
                        break block112;
                    }
                    default: {
                        throw new SQLException("Conversion not allowed", "M1M05");
                    }
                }
            }
            if (x instanceof Array) {
                this.setArray(parameterIndex, (Array)x);
            } else if (x instanceof Blob) {
                this.setBlob(parameterIndex, (Blob)x);
            } else if (x instanceof Clob) {
                this.setClob(parameterIndex, (Clob)x);
            } else {
                if (x instanceof Struct) {
                    throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject() with object of type Struct");
                }
                if (x instanceof Ref) {
                    this.setRef(parameterIndex, (Ref)x);
                } else if (x instanceof URL) {
                    this.setURL(parameterIndex, (URL)x);
                } else if (x instanceof RowId) {
                    this.setRowId(parameterIndex, (RowId)x);
                } else {
                    if (x instanceof SQLXML) {
                        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject() with object of type SQLXML");
                    }
                    if (x instanceof SQLData) {
                        SQLData sx = (SQLData)x;
                        final int paramnr = parameterIndex;
                        final String sqltype = sx.getSQLTypeName();
                        SQLOutput out = new SQLOutput(){

                            @Override
                            public void writeString(String x) throws SQLException {
                                MonetPreparedStatement.this.setValue(paramnr, sqltype + " '" + x.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'") + "'");
                            }

                            @Override
                            public void writeBoolean(boolean x) throws SQLException {
                                MonetPreparedStatement.this.setBoolean(paramnr, x);
                            }

                            @Override
                            public void writeByte(byte x) throws SQLException {
                                MonetPreparedStatement.this.setByte(paramnr, x);
                            }

                            @Override
                            public void writeShort(short x) throws SQLException {
                                MonetPreparedStatement.this.setShort(paramnr, x);
                            }

                            @Override
                            public void writeInt(int x) throws SQLException {
                                MonetPreparedStatement.this.setInt(paramnr, x);
                            }

                            @Override
                            public void writeLong(long x) throws SQLException {
                                MonetPreparedStatement.this.setLong(paramnr, x);
                            }

                            @Override
                            public void writeFloat(float x) throws SQLException {
                                MonetPreparedStatement.this.setFloat(paramnr, x);
                            }

                            @Override
                            public void writeDouble(double x) throws SQLException {
                                MonetPreparedStatement.this.setDouble(paramnr, x);
                            }

                            @Override
                            public void writeBigDecimal(BigDecimal x) throws SQLException {
                                MonetPreparedStatement.this.setBigDecimal(paramnr, x);
                            }

                            @Override
                            public void writeBytes(byte[] x) throws SQLException {
                                MonetPreparedStatement.this.setBytes(paramnr, x);
                            }

                            @Override
                            public void writeDate(Date x) throws SQLException {
                                MonetPreparedStatement.this.setDate(paramnr, x);
                            }

                            @Override
                            public void writeTime(Time x) throws SQLException {
                                MonetPreparedStatement.this.setTime(paramnr, x);
                            }

                            @Override
                            public void writeTimestamp(Timestamp x) throws SQLException {
                                MonetPreparedStatement.this.setTimestamp(paramnr, x);
                            }

                            @Override
                            public void writeCharacterStream(Reader x) throws SQLException {
                                MonetPreparedStatement.this.setCharacterStream(paramnr, x);
                            }

                            @Override
                            public void writeAsciiStream(InputStream x) throws SQLException {
                                MonetPreparedStatement.this.setAsciiStream(paramnr, x);
                            }

                            @Override
                            public void writeBinaryStream(InputStream x) throws SQLException {
                                MonetPreparedStatement.this.setBinaryStream(paramnr, x);
                            }

                            @Override
                            public void writeObject(SQLData x) throws SQLException {
                                MonetPreparedStatement.this.setObject(paramnr, x);
                            }

                            @Override
                            public void writeRef(Ref x) throws SQLException {
                                MonetPreparedStatement.this.setRef(paramnr, x);
                            }

                            @Override
                            public void writeBlob(Blob x) throws SQLException {
                                MonetPreparedStatement.this.setBlob(paramnr, x);
                            }

                            @Override
                            public void writeClob(Clob x) throws SQLException {
                                MonetPreparedStatement.this.setClob(paramnr, x);
                            }

                            @Override
                            public void writeStruct(Struct x) throws SQLException {
                                MonetPreparedStatement.this.setObject(paramnr, x);
                            }

                            @Override
                            public void writeArray(Array x) throws SQLException {
                                MonetPreparedStatement.this.setArray(paramnr, x);
                            }

                            @Override
                            public void writeURL(URL x) throws SQLException {
                                MonetPreparedStatement.this.setURL(paramnr, x);
                            }

                            @Override
                            public void writeNString(String x) throws SQLException {
                                MonetPreparedStatement.this.setNString(paramnr, x);
                            }

                            @Override
                            public void writeNClob(NClob x) throws SQLException {
                                MonetPreparedStatement.this.setNClob(paramnr, x);
                            }

                            @Override
                            public void writeRowId(RowId x) throws SQLException {
                                MonetPreparedStatement.this.setRowId(paramnr, x);
                            }

                            @Override
                            public void writeSQLXML(SQLXML x) throws SQLException {
                                MonetPreparedStatement.this.setSQLXML(paramnr, x);
                            }
                        };
                        sx.writeSQL(out);
                    } else {
                        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject() with object of type Class");
                    }
                }
            }
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        this.setValue(parameterIndex, "'" + x.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'") + "'");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setTime(int index, Time x) throws SQLException {
        this.setTime(index, x, null);
    }

    @Override
    public void setTime(int index, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(index, -1);
            return;
        }
        boolean hasTimeZone = this.monetdbType[this.getParamIdx(index)].endsWith("tz");
        if (hasTimeZone) {
            String RFC822 = this.mTimeZ.format(x);
            this.setValue(index, "timetz '" + RFC822.substring(0, 15) + ":" + RFC822.substring(15) + "'");
        } else if (cal == null) {
            this.setValue(index, "time '" + x.toString() + "'");
        } else {
            this.mTime.setTimeZone(cal.getTimeZone());
            this.setValue(index, "time '" + this.mTime.format(x) + "'");
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp x) throws SQLException {
        this.setTimestamp(index, x, null);
    }

    @Override
    public void setTimestamp(int index, Timestamp x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(index, -1);
            return;
        }
        boolean hasTimeZone = this.monetdbType[this.getParamIdx(index)].endsWith("tz");
        if (hasTimeZone) {
            String RFC822 = this.mTimestampZ.format(x);
            this.setValue(index, "timestamptz '" + RFC822.substring(0, 26) + ":" + RFC822.substring(26) + "'");
        } else if (cal == null) {
            this.setValue(index, "timestamp '" + x.toString() + "'");
        } else {
            this.mTimestamp.setTimeZone(cal.getTimeZone());
            this.setValue(index, "timestamp '" + this.mTimestamp.format(x) + "'");
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setString(parameterIndex, x.toString());
        this.values[this.getParamIdx((int)parameterIndex)] = "url " + this.values[this.getParamIdx(parameterIndex)];
    }

    @Override
    public void close() {
        try {
            if (!this.closed && this.id != -1) {
                this.connection.sendControlCommand(3, this.id);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
    }

    protected void finalize() {
        this.close();
    }

    private void setValue(int index, String val) throws SQLException {
        this.values[this.getParamIdx((int)index)] = val;
    }

    private String transform() throws SQLException {
        StringBuilder buf = new StringBuilder(8 + 12 * this.size);
        buf.append("exec ");
        buf.append(this.id);
        buf.append('(');
        int col = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] != null) continue;
            if (++col > 1) {
                buf.append(',');
            }
            if (this.values[i] == null) {
                throw new SQLException("Cannot execute, parameter " + col + " is missing.", "M1M05");
            }
            buf.append(this.values[i]);
        }
        buf.append(')');
        return buf.toString();
    }

    private static SQLException newSQLInvalidParameterIndexException(int paramIdx) {
        return new SQLException("Invalid Parameter Index number: " + paramIdx, "M1M05");
    }

    private static SQLFeatureNotSupportedException newSQLFeatureNotSupportedException(String name) {
        return new SQLFeatureNotSupportedException("Method " + name + " not implemented", "0A000");
    }

    private abstract class pmdw
    extends MonetWrapper
    implements ParameterMetaData {
        private pmdw() {
        }
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

