/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetDatabaseMetaData;
import nl.cwi.monetdb.jdbc.MonetINET;
import nl.cwi.monetdb.jdbc.MonetPreparedStatement;
import nl.cwi.monetdb.jdbc.MonetSavepoint;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetURL;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.mcl.connection.IMonetDBLanguage;
import nl.cwi.monetdb.mcl.connection.MCLException;
import nl.cwi.monetdb.mcl.connection.SenderThread;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.AutoCommitResponse;
import nl.cwi.monetdb.mcl.responses.IIncompleteResponse;
import nl.cwi.monetdb.mcl.responses.IResponse;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;

public abstract class MonetConnection
extends MonetWrapper
implements Connection {
    private static int SeqCounter = 0;
    protected final Properties conn_props;
    protected IMonetDBLanguage language;
    protected final String hash;
    private SenderThread senderThread;
    private boolean closed;
    private boolean autoCommit = true;
    private SQLWarning warnings;
    private Map<String, Class<?>> typeMap = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("inet", MonetINET.class);
            this.put("url", MonetURL.class);
        }
    };
    private Map<Statement, ?> statements = new WeakHashMap();
    private int curReplySize = -1;
    private final boolean blobIsBinary;
    private final boolean clobIsLongChar;
    protected AbstractProtocol protocol;
    private final boolean isEmbedded;

    public static int getSeqCounter() {
        return SeqCounter;
    }

    public MonetConnection(Properties props, String hash, IMonetDBLanguage language, boolean blobIsBinary, boolean clobIsLongChar) throws IOException {
        this.conn_props = props;
        this.hash = hash;
        this.language = language;
        this.blobIsBinary = blobIsBinary;
        this.clobIsLongChar = clobIsLongChar;
        this.isEmbedded = props.getProperty("embedded", "false").equals("true");
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public IMonetDBLanguage getLanguage() {
        return this.language;
    }

    public AbstractProtocol getProtocol() {
        return this.protocol;
    }

    public abstract List<String> connect(String var1, String var2) throws IOException, ProtocolException, MCLException;

    public abstract int getBlockSize();

    public abstract int getDefFetchsize();

    public abstract int initialStringBuilderSize();

    public abstract int getSoTimeout();

    public abstract void setSoTimeout(int var1);

    public abstract void closeUnderlyingConnection() throws IOException;

    public abstract String getJDBCURL();

    public abstract void sendControlCommand(int var1, int var2) throws SQLException;

    @Override
    public void close() {
        for (Statement st : this.statements.keySet()) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            this.closeUnderlyingConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.senderThread != null) {
            this.senderThread.shutdown();
            this.senderThread = null;
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    private void createResponseList(String query) throws SQLException {
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery(query);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.createResponseList("COMMIT");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            MonetStatement ret = new MonetStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.statements.put(ret, null);
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (!this.language.getRepresentation().equals("sql")) {
            throw new SQLException("This method is only supported in SQL mode", "M0M04");
        }
        return new MonetDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() {
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            MonetPreparedStatement ret = new MonetPreparedStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, sql);
            this.statements.put(ret, null);
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint sp = (MonetSavepoint)savepoint;
        this.createResponseList("RELEASE SAVEPOINT " + sp.getName());
    }

    @Override
    public void rollback() throws SQLException {
        this.createResponseList("ROLLBACK");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint sp = (MonetSavepoint)savepoint;
        this.createResponseList("ROLLBACK TO SAVEPOINT " + sp.getName());
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit != autoCommit) {
            this.sendControlCommand(1, autoCommit ? 1 : 0);
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCatalog(String catalog) not supported", "0A000");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("setHoldability(CLOSE_CURSORS_AT_COMMIT) not supported", "0A000");
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            this.addWarning("cannot setReadOnly(true): read-only Connection mode not supported", "01M08");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        MonetSavepoint sp = new MonetSavepoint();
        this.createResponseList("SAVEPOINT " + sp.getName());
        return sp;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        MonetSavepoint sp;
        try {
            sp = new MonetSavepoint(name);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.getMessage(), "M0M03");
        }
        this.createResponseList("SAVEPOINT " + sp.getName());
        return sp;
    }

    @Override
    public void setTransactionIsolation(int level) {
        if (level != 8) {
            this.addWarning("MonetDB only supports fully serializable transactions, continuing with transaction level raised to TRANSACTION_SERIALIZABLE", "01M09");
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    public String toString() {
        return "MonetDB Connection (" + this.getJDBCURL() + ") " + (this.closed ? "disconnected" : "connected");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf() not supported", "0A000");
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MonetClob("");
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MonetBlob(new byte[1]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob() not supported", "0A000");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct() not supported", "0A000");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML() not supported", "0A000");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout is less than 0", "M1M05");
        }
        if (this.closed) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            stmt.setQueryTimeout(timeout);
            rs = stmt.executeQuery("SELECT 1");
            rs.close();
            rs = null;
            stmt.close();
            return true;
        }
        catch (Exception e) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.conn_props.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties(this.conn_props);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name == null || name.isEmpty()) {
            this.addWarning("setClientInfo: missing property name", "01M07");
            return;
        }
        if (value == null) {
            if (this.conn_props.containsKey(name)) {
                this.conn_props.remove(name);
            }
            return;
        }
        if (name.equals("host") || name.equals("port") || name.equals("user") || name.equals("password") || name.equals("database") || name.equals("language") || name.equals("so_timeout") || name.equals("hash") || name.equals("treat_blob_as_binary") || name.equals("follow_redirects") || name.equals("treat_clob_as_longvarchar") || name.equals("embedded") || name.equals("directory")) {
            this.conn_props.setProperty(name, value);
        } else {
            this.addWarning("setClientInfo: " + name + "is not a recognised property", "01M07");
        }
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.setClientInfo(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        if (schema == null) {
            throw new SQLException("Missing schema name", "M1M05");
        }
        try (Statement st = this.createStatement();){
            st.execute("SET SCHEMA \"" + schema + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        String cur_schema;
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        Statement st = this.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT CURRENT_SCHEMA");
            if (!rs.next()) {
                throw new SQLException("Row expected", "02000");
            }
            cur_schema = rs.getString(1);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return cur_schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int millis) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        if (millis < 0) {
            throw new SQLException("milliseconds is less than zero", "M1M05");
        }
        this.setSoTimeout(millis);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        return this.getSoTimeout();
    }

    public boolean getBlobAsBinary() {
        return this.blobIsBinary;
    }

    public boolean getClobAsLongChar() {
        return this.clobIsLongChar;
    }

    void sendIndependentCommand(String command) throws SQLException {
        try {
            this.protocol.writeNextQuery(this.language.getQueryTemplateIndex(0), command, this.language.getQueryTemplateIndex(1));
            this.protocol.waitUntilPrompt();
            int csrh = this.protocol.getCurrentServerResponse();
            if (csrh == 1) {
                String error = this.protocol.getRemainingStringLine(0);
                throw new SQLException(error.substring(6), error.substring(0, 5));
            }
        }
        catch (SocketTimeoutException e) {
            this.close();
            throw new SQLException("connection timed out", "08M33");
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), "08000");
        }
    }

    protected void addWarning(String reason, String sqlstate) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(reason, sqlstate);
        } else {
            this.warnings.setNextWarning(new SQLWarning(reason, sqlstate));
        }
    }

    public class ResponseList {
        private final int cachesize;
        private final int maxrows;
        private final int rstype;
        private final int rsconcur;
        private final int seqnr;
        private final List<IResponse> responses = new ArrayList<IResponse>();
        private Map<Integer, ResultSetResponse> rsresponses;
        private int curResponse = -1;

        ResponseList(int cachesize, int maxrows, int rstype, int rsconcur) {
            this.cachesize = cachesize;
            this.maxrows = maxrows;
            this.rstype = rstype;
            this.rsconcur = rsconcur;
            this.seqnr = SeqCounter++;
        }

        public int getCachesize() {
            return this.cachesize;
        }

        public int getRstype() {
            return this.rstype;
        }

        public int getRsconcur() {
            return this.rsconcur;
        }

        public int getMaxrows() {
            return this.maxrows;
        }

        IResponse getNextResponse() throws SQLException {
            if (this.rstype == 1003 && this.curResponse >= 0 && this.curResponse < this.responses.size()) {
                IResponse tmp = this.responses.get(this.curResponse);
                if (tmp != null) {
                    tmp.close();
                }
                this.responses.set(this.curResponse, null);
            }
            ++this.curResponse;
            if (this.curResponse >= this.responses.size()) {
                return null;
            }
            return this.responses.get(this.curResponse);
        }

        void closeResponse(int i) {
            if (i < 0 || i >= this.responses.size()) {
                return;
            }
            IResponse tmp = this.responses.set(i, null);
            if (tmp != null) {
                tmp.close();
            }
        }

        void closeCurrentResponse() {
            this.closeResponse(this.curResponse);
        }

        void closeCurOldResponses() {
            for (int i = this.curResponse; i >= 0; --i) {
                this.closeResponse(i);
            }
        }

        public void close() {
            for (int i = 0; i < this.responses.size(); ++i) {
                this.closeResponse(i);
            }
        }

        boolean hasUnclosedResponses() {
            for (IResponse r : this.responses) {
                if (r == null) continue;
                return true;
            }
            return false;
        }

        void processQuery(String query) throws SQLException {
            this.executeQuery(MonetConnection.this.language.getQueryTemplates(), query);
        }

        public void executeQuery(String[] templ, String query) throws SQLException {
            String error = null;
            try {
                String tmp;
                MonetConnection.this.protocol.waitUntilPrompt();
                int size = this.cachesize != 0 && !MonetConnection.this.isEmbedded ? this.cachesize : MonetConnection.this.getDefFetchsize();
                int n = size = this.maxrows != 0 ? Math.min(this.maxrows, size) : size;
                if (!MonetConnection.this.isEmbedded && MonetConnection.this.language.getRepresentation().equals("sql") && size != MonetConnection.this.curReplySize && !Arrays.deepEquals(templ, MonetConnection.this.language.getCommandTemplates())) {
                    MonetConnection.this.sendControlCommand(2, size);
                    MonetConnection.this.curReplySize = size;
                }
                if (query.length() > MonetConnection.this.getBlockSize()) {
                    if (MonetConnection.this.senderThread == null) {
                        MonetConnection.this.senderThread = new SenderThread(MonetConnection.this.protocol);
                    }
                    MonetConnection.this.senderThread.runQuery(templ, query);
                } else {
                    MonetConnection.this.protocol.writeNextQuery(templ[0] == null ? "" : templ[0], query, templ[1] == null ? "" : templ[1]);
                }
                MonetConnection.this.protocol.fetchNextResponseData();
                int nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                IResponse res = null;
                block20: while (nextResponse != 4) {
                    switch (nextResponse) {
                        case 6: {
                            int nextStartHeader = MonetConnection.this.protocol.getNextStarterHeader();
                            try {
                                switch (nextStartHeader) {
                                    case 0: {
                                        throw new ProtocolException("Q_PARSE header not allowed here");
                                    }
                                    case 1: 
                                    case 5: {
                                        res = MonetConnection.this.protocol.getNextResultSetResponse(MonetConnection.this, this, this.seqnr, this.maxrows);
                                        ResultSetResponse rsreponse = (ResultSetResponse)res;
                                        if (this.rsresponses == null) {
                                            this.rsresponses = new HashMap<Integer, ResultSetResponse>();
                                        }
                                        this.rsresponses.put(rsreponse.getId(), rsreponse);
                                        break;
                                    }
                                    case 2: {
                                        res = MonetConnection.this.protocol.getNextUpdateResponse();
                                        break;
                                    }
                                    case 3: {
                                        res = MonetConnection.this.protocol.getNextSchemaResponse();
                                        break;
                                    }
                                    case 4: {
                                        res = MonetConnection.this.protocol.getNextAutoCommitResponse();
                                        boolean isAutoCommit = ((AutoCommitResponse)res).isAutocommit();
                                        if (MonetConnection.this.getAutoCommit() && isAutoCommit) {
                                            MonetConnection.this.addWarning("Server enabled auto commit mode while local state already was auto commit.", "01M11");
                                        }
                                        MonetConnection.this.autoCommit = isAutoCommit;
                                        break;
                                    }
                                    case 6: {
                                        AbstractDataBlockResponse next = MonetConnection.this.protocol.getNextDatablockResponse(this.rsresponses);
                                        if (next == null) {
                                            error = "M0M12!No ResultSetResponse for a DataBlock found";
                                            break;
                                        }
                                        res = next;
                                    }
                                }
                            }
                            catch (ProtocolException e) {
                                error = "M0M10!error while parsing start of header:\n" + e.getMessage() + " found: '" + MonetConnection.this.protocol.getRemainingStringLine(0).charAt(e.getErrorOffset()) + "' in: \"" + MonetConnection.this.protocol.getRemainingStringLine(0) + "\" at pos: " + e.getErrorOffset();
                                MonetConnection.this.protocol.waitUntilPrompt();
                                nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                                continue block20;
                            }
                            if (error != null) {
                                MonetConnection.this.protocol.waitUntilPrompt();
                                nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                                continue block20;
                            }
                            if (res instanceof IIncompleteResponse) {
                                IIncompleteResponse iter = (IIncompleteResponse)res;
                                while (iter.wantsMore()) {
                                    try {
                                        MonetConnection.this.protocol.fetchNextResponseData();
                                        iter.addLines(MonetConnection.this.protocol);
                                    }
                                    catch (ProtocolException ex) {
                                        error = "M0M10!" + ex.getMessage();
                                        MonetConnection.this.protocol.waitUntilPrompt();
                                        nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                                        break;
                                    }
                                }
                            }
                            if (error != null) continue block20;
                            if (!(res instanceof AbstractDataBlockResponse)) {
                                this.responses.add(res);
                            }
                            MonetConnection.this.protocol.fetchNextResponseData();
                            nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                            continue block20;
                        }
                        case 8: {
                            MonetConnection.this.addWarning(MonetConnection.this.protocol.getRemainingStringLine(0), "01000");
                            MonetConnection.this.protocol.fetchNextResponseData();
                            nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                            continue block20;
                        }
                        case 1: {
                            error = MonetConnection.this.protocol.getRemainingStringLine(0);
                            MonetConnection.this.protocol.waitUntilPrompt();
                            nextResponse = MonetConnection.this.protocol.getCurrentServerResponse();
                            continue block20;
                        }
                    }
                    throw new SQLException("Protocol violation, unexpected line!", "M0M10");
                }
                if (MonetConnection.this.senderThread != null && (tmp = MonetConnection.this.senderThread.getErrors()) != null) {
                    error = error == null ? "08000!" + tmp : error + "\n08000!" + tmp;
                }
                if (error != null) {
                    String[] errorsList;
                    SQLException ret = null;
                    for (String singleError : errorsList = error.split("\n")) {
                        String sqlState;
                        String reason = MonetConnection.this.isEmbedded() ? singleError : singleError.substring(6);
                        String string = sqlState = MonetConnection.this.isEmbedded() ? "M0M10" : singleError.substring(0, 5);
                        if (ret == null) {
                            ret = new SQLException(reason, sqlState);
                            continue;
                        }
                        ret.setNextException(new SQLException(reason, sqlState));
                    }
                    throw ret;
                }
            }
            catch (SocketTimeoutException e) {
                this.close();
                throw new SQLException("connection timed out", "08M33");
            }
            catch (IOException e) {
                MonetConnection.this.closed = true;
                throw new SQLException(e.getMessage() + " (mserver still alive?)", "08000");
            }
        }
    }
}

