package rababah.mohmmad.mrwebservice;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by hp on 13/02/2017.
 */

 class MRMultiPartAsyncTask {

    static ExecutorService executorService = Executors.newFixedThreadPool(100);
    private String urlString;
    private MRWebListener mrWebListener;
    private HashMap<String, File> fileList;

    public MRMultiPartAsyncTask(String urlString, HashMap<String, File> fileList, MRWebListener mrWebListener) {
        this.urlString = urlString;
        this.mrWebListener = mrWebListener;
        this.fileList = fileList;
    }

    public void execute() {
        executorService.submit(new URLLoader(urlString, fileList, mrWebListener));
    }


    class URLLoader implements Runnable {
        private String urlString;
        private HashMap<String, File> file;
        private MRWebListener mrWebListener;

        URLLoader(String urlString, HashMap<String, File> file, MRWebListener mrWebListener) {
            this.file = file;
            this.mrWebListener = mrWebListener;
            this.urlString = urlString;
        }

        @Override
        public void run() {
            try {
                MRMultiPartUtility multipart = new MRMultiPartUtility(urlString);
                for (String key : file.keySet()) {
                    multipart.addFilePart(key, file.get(key));
                }

                List<String> response = multipart.finish();
                mrWebListener.onSuccess(response.get(0));
            } catch (IOException e) {
                mrWebListener.onFail(e);
            }
        }
    }
}
