package rababah.mohmmad.mrwebservice;

import com.google.gson.Gson;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;

/**
 * Created by hp on 12/02/2017.
 */

public class MRClientWebService {
    private MRWebListener mrWebListener;

    public MRClientWebService() {
    }

    public <T> void invokeRemoteService(final String urlString, HashMap<String, String> pramsHashMap,
                                        final Class<T> tClass, final MRWebListener mrWebListener) {
        this.mrWebListener = new MRWebListener() {
            @Override
            public void onSuccess(Object tObject) {
                Gson gson = new Gson();
                try {
                    JSONObject jsonObject = new JSONObject(tObject.toString());
                    T responses = gson.fromJson(jsonObject.toString(), tClass);
                    mrWebListener.onSuccess(responses);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

            @Override
            public void onFail(Exception e) {
                mrWebListener.onFail(e);

            }
        };

        MRAsyncTask gAsyncTask = new MRAsyncTask(urlString, pramsHashMap, this.mrWebListener);
        gAsyncTask.execute();


    }

   
   
    public void invokeStringService(final String urlString, HashMap<String, String> pramsHashMap, final MRWebListener mrWebListener) {
        this.mrWebListener = new MRWebListener() {
            @Override
            public void onSuccess(Object tObject) {
                mrWebListener.onSuccess(tObject);
            }

            @Override
            public void onFail(Exception e) {
                mrWebListener.onFail(e);
            }
        };

        MRAsyncTask gAsyncTask = new MRAsyncTask(urlString, pramsHashMap, this.mrWebListener);
        gAsyncTask.execute();


    }

    public void invokeFileService(final String urlString, HashMap<String,File> file, final MRWebListener mrWebListener) {
        this.mrWebListener = new MRWebListener() {
            @Override
            public void onSuccess(Object tObject) {
                mrWebListener.onSuccess(tObject);
            }

            @Override
            public void onFail(Exception e) {
                mrWebListener.onFail(e);
            }
        };

       MRMultiPartAsyncTask multiPartAsync = new MRMultiPartAsyncTask(urlString, file, this.mrWebListener);
        multiPartAsync.execute();


    }

    public void invokeListWebService(String urlString, HashMap<String, String> pramsHashMap,
                                     final Type type, final MRWebListener mrWebListener) {
        this.mrWebListener = new MRWebListener() {
            @Override
            public void onSuccess(Object tObject) {
                Gson gson = new Gson();
                mrWebListener.onSuccess(gson.fromJson(tObject.toString(), type));
            }

            @Override
            public void onFail(Exception e) {
                mrWebListener.onFail(e);
            }
        };
        MRAsyncTask gAsyncTask = new MRAsyncTask(urlString, pramsHashMap, this.mrWebListener);
        gAsyncTask.execute();
    }
}
