package rababah.mohmmad.mrwebservice;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by hp on 12/02/2017.
 */

 class MRAsyncTask {
    private static final String POST = "POST";
    private static final String UTF8 = "UTF-8";
    private String urlString;
    HashMap<String, String> pramsHashMap;
    public static Map<String, Boolean> stringBooleanMap = Collections.synchronizedMap(new HashMap<String, Boolean>());
    MRWebListener gWebListener;
    private final static ExecutorService executorService = Executors.newFixedThreadPool(4);


    MRAsyncTask(String urlString, HashMap<String, String> pramsHashMap, MRWebListener gWebListener) {
        this.pramsHashMap = pramsHashMap;
        this.gWebListener = gWebListener;
        this.urlString = urlString;
    }

    public void execute() {
        executorService.submit(new URLLoader(urlString, pramsHashMap, gWebListener));
    }

    private String getWebResponse(HttpURLConnection httpURLConnection) throws IOException {
        String results = null;
        if (httpURLConnection != null && httpURLConnection.getResponseCode() == HttpURLConnection.HTTP_OK) {
            InputStream inputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder();
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                response.append(line);
            }
            results = response.toString();
        } else {
            gWebListener.onFail(new Exception("Cannot Connect To server"));
        }
        return results;
    }

    class URLLoader implements Runnable {
        private String urlString;
        private HashMap<String, String> pramsHashMap;
        private MRWebListener mrWebListener;

        URLLoader(String urlString, HashMap<String, String> pramsHashMap, MRWebListener mrWebListener) {
            this.pramsHashMap = pramsHashMap;
            this.mrWebListener = mrWebListener;
            this.urlString = urlString;
        }

        @Override
        public void run() {
            BufferedWriter bufferedWriter = null;
            OutputStream outputStream = null;
            HttpURLConnection httpURLConnection = null;
            String results = null;
            try {
                URL url = new URL(urlString);
                httpURLConnection = (HttpURLConnection) url.openConnection();
                httpURLConnection.setRequestMethod(POST);
                outputStream = httpURLConnection.getOutputStream();
                bufferedWriter = new BufferedWriter(
                        new OutputStreamWriter(outputStream, UTF8));
                if (pramsHashMap != null) {
                    int i = 0;
                    bufferedWriter.write("");
                    for (String key : pramsHashMap.keySet()) {
                        bufferedWriter.append(URLEncoder.encode(key, UTF8) + "=" + URLEncoder.encode(pramsHashMap.get(key), UTF8));
                        if (i < pramsHashMap.size() - 1) {
                            bufferedWriter.append('&');
                        }
                    }
                }
            } catch (IOException e) {
                mrWebListener.onFail(e);

            } finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    if (outputStream != null)
                        outputStream.close();
                } catch (Exception ex) {
                    ex.printStackTrace();
                    mrWebListener.onFail(ex);
                }
            }
            try {
                results = getWebResponse(httpURLConnection);
            } catch (java.net.SocketTimeoutException e) {
                mrWebListener.onFail(e);
            } catch (IOException e) {
                mrWebListener.onFail(e);
            }
            if (results != null) {
                httpURLConnection.disconnect();
                try {
                    mrWebListener.onSuccess(new JSONObject(results));
                } catch (JSONException e) {
                    mrWebListener.onSuccess(results);
                }
            }

        }
    }

}