package moe.kaede.droids.dispatcher;

import android.support.annotation.NonNull;

/**
 * Runnable wrapper used in the work queue of the dispatcher.
 *
 * @author kaede
 * @version date 16/10/25
 */
class ComparableTask implements Runnable, Comparable<ComparableTask> {

    public static ComparableTask obtain(Task.Dispatcher dispatcher, Runnable runnable) {
        // TODO: 16/10/25 Using object pools.
        return new ComparableTask(dispatcher, runnable);
    }

    final Runnable mRunnable;
    final Task.Dispatcher mDispatcher;

    private ComparableTask(Task.Dispatcher dispatcher, Runnable runnable) {
        mDispatcher = dispatcher;
        mRunnable = runnable;
    }

    @Override
    public void run() {
        mRunnable.run();
        mDispatcher.finish(this);
    }

    @Override
    public int compareTo(@NonNull ComparableTask another) {
        if (mRunnable instanceof Comparable && another.mRunnable instanceof Comparable) {
            return ((Comparable) mRunnable).compareTo(another.mRunnable);
        }

        return 0;
    }
}
