/*
 * Copyright (c) 2016. Kaede
 */

package moe.kaede.dispatcher;

import android.os.Build;
import android.support.annotation.NonNull;
import android.util.SparseArray;

/**
 * @author kaede
 * @version date 16/10/25
 */
class TaskTracker {

    private final SparseArray<Runnable> mTaskMap;

    public TaskTracker() {
        mTaskMap = new SparseArray<>();
    }

    public boolean has(int key) {
        return mTaskMap.get(key) != null;
    }

    public boolean has(@NonNull Runnable runnable) {
        return mTaskMap.indexOfValue(runnable) >= 0;
    }

    public void put(int key, @NonNull Runnable runnable) {
        mTaskMap.put(key, runnable);
    }

    public boolean remove(int key) {
        Runnable runnable = mTaskMap.get(key);

        if (runnable == null) {
            return false;
        }

        mTaskMap.remove(key);
        return true;
    }

    public boolean remove(@NonNull Runnable runnable) {
        int index = mTaskMap.indexOfValue(runnable);

        if (index < 0) {
            return false;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            mTaskMap.removeAt(index);
        } else {
            int key = mTaskMap.keyAt(index);
            mTaskMap.remove(key);
        }

        return true;
    }

}
