/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects;

import com.mockobjects.AbstractExpectation;
import junit.framework.Assert;

public class ExpectationCounter
extends AbstractExpectation {
    private int myExpectedCalls = 0;
    private int myActualCalls = 0;

    public ExpectationCounter(String name) {
        super(name);
    }

    public void clearActual() {
        this.myActualCalls = 0;
    }

    public void inc() {
        ++this.myActualCalls;
        if (this.shouldCheckImmediately()) {
            Assert.assertTrue((String)(String.valueOf(this.myName) + " should not be called more than " + this.myExpectedCalls + " times"), (this.myActualCalls <= this.myExpectedCalls ? 1 : 0) != 0);
        }
    }

    public void setExpected(int expectedCalls) {
        this.myExpectedCalls = expectedCalls;
        this.setHasExpectations();
    }

    public void setExpectNothing() {
        this.myExpectedCalls = 0;
        this.setHasExpectations();
    }

    public void verify() {
        this.assertEquals("did not receive the expected Count.", this.myExpectedCalls, this.myActualCalls);
    }
}

