
package com.xiaomi.market.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import java.io.File;
import java.lang.reflect.Method;

public class Utils {
    static final String TAG = "MarketSdkUtils";
    static boolean DEBUG = new File("/sdcard/com.xiaomi.market.sdk/sdk_debug").exists();
    static boolean STAGING = new File("/sdcard/com.xiaomi.market.sdk/sdk_staging").exists();

    // 统一使用1000为换算单位
    protected static final int BYTES_IN_MEGA = 1000 * 1000;
    protected static final int BYTES_IN_KILO = 1000;

    /**
     * 通过判断CloudService是否存在来判断是否是miui，小米账户如果不存在的话认为不是miui
     */
    static boolean isMiui(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo pkgInfo = packageManager.getPackageInfo("com.miui.cloudservice", 0);
            return (pkgInfo.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0;
        } catch (NameNotFoundException e) {
            return false;
        }
    }

    static boolean isMiuiMarketExisted(Context context) {
        if (context == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            int enableFlag = pm.getApplicationEnabledSetting("com.xiaomi.market");
            return enableFlag == PackageManager.COMPONENT_ENABLED_STATE_DEFAULT
                    || enableFlag == PackageManager.COMPONENT_ENABLED_STATE_ENABLED;
        } catch (IllegalArgumentException e) {
        }
        return false;
    }

    static boolean isMiuiPad() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getMethod = clazz.getDeclaredMethod("get", String.class);
            String result = (String) getMethod.invoke(clazz, "ro.build.characteristics");
            return result.contains("tablet");
        } catch (Exception e) {
            Log.e(TAG, e.getMessage(), e);
        }
        return false;
    }

    /**
     * 返回字节数对应的字符串，换算至KB或MB
     */
    public static String getByteString(long bytes, Context context) {
        if (context == null) {
            return "";
        }
        if (bytes < 0) {
            return "";
        }
        String value = null;
        int unitRes = 0;
        if (bytes > BYTES_IN_MEGA) {
            value = String.format("%.1f", (double) (bytes * 1.0 / BYTES_IN_MEGA));
            unitRes = R.string.xiaomi_update_sdk_megabytes_unit;
        } else if (bytes > BYTES_IN_KILO) {
            value = String.format("%.1f", (double) (bytes * 1.0 / BYTES_IN_KILO));
            unitRes = R.string.xiaomi_update_sdk_kilobytes_unit;
        } else {
            value = String.valueOf(bytes);
            unitRes = R.string.xiaomi_update_sdk_bytes_unit;
        }
        return context.getString(unitRes, value);
    }

    static boolean isConnected(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager connManager =
                (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    static boolean isWifiConnected(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager connManager = (ConnectivityManager) context.
                getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        return networkInfo != null &&
                networkInfo.getType() == ConnectivityManager.TYPE_WIFI;
    }

    static boolean isMobileConnected(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager connManager = (ConnectivityManager) context.
                getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        return networkInfo != null &&
                networkInfo.getType() == ConnectivityManager.TYPE_MOBILE;
    }

    /**
     * 检查外部存储是否存在
     * 
     * @param requireWriteAccess 是否要求可写
     * @return 当外部存储可读写时,或者在requireWriteAccess为false, 而外部存储可读时,返回true,否则返回false
     */
    static boolean hasExternalStorage(boolean requireWriteAccess) {
        String state = Environment.getExternalStorageState();
        if (Environment.MEDIA_MOUNTED.equals(state)) {
            return true;
        } else if (Environment.MEDIA_MOUNTED_READ_ONLY.equals(state) && !requireWriteAccess) {
            return true;
        }
        return false;
    }
}
