
package com.xiaomi.market.sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;

import com.xiaomi.market.sdk.Constants.Update;

public class SDKDatabaseHelper extends SQLiteOpenHelper {
    private static SDKDatabaseHelper mHelper;

    public static SDKDatabaseHelper getHelper(Context context) {
        if (mHelper == null) {
            mHelper = new SDKDatabaseHelper(context);
        }
        return mHelper;
    }

    private static final String TAG = "MarketSDKDatabaseHelper";

    static final String DATABASE_NAME = "xiaomi_market_sdk_update.db";
    static final int DATABASE_VERSION = 1;

    private SDKDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        Log.d(TAG, "create database");
        createDownloadTable(db);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    private void createDownloadTable(SQLiteDatabase db) {
        db.execSQL(Update.CREATE_TABLE);
    }

    public synchronized long insert(String table, ContentValues values) {
        SQLiteDatabase db = getWritableDatabase();
        return db.insert(table, null, values);
    }

    public long insertOrUpdateUpdate(ContentValues values) {
        SQLiteDatabase db = getWritableDatabase();
        String sql = "INSERT OR REPLACE INTO " + Update.TABLE +
                "(" +
                Update.PACKAGE_NAME + "," +
                Update.DOWNLOAD_ID + "," +
                Update.VERSION_CODE + "," +
                Update.APK_URL + "," +
                Update.APK_HASH + "," +
                Update.DIFF_URL + "," +
                Update.DIFF_HASH + "," +
                Update.APK_PATH +
                ") " +
                "VALUES(?,?,?,?,?,?,?,?)";
        SQLiteStatement insertOrUpdate = db.compileStatement(sql);
        insertOrUpdate.bindString(1, values.getAsString(Update.PACKAGE_NAME));
        insertOrUpdate.bindLong(2, values.getAsLong(Update.DOWNLOAD_ID));
        insertOrUpdate.bindLong(3, values.getAsInteger(Update.VERSION_CODE));
        insertOrUpdate.bindString(4, values.getAsString(Update.APK_URL));
        insertOrUpdate.bindString(5, values.getAsString(Update.APK_HASH));
        insertOrUpdate.bindString(6, values.getAsString(Update.DIFF_URL));
        insertOrUpdate.bindString(7, values.getAsString(Update.DIFF_HASH));
        insertOrUpdate.bindString(8, values.getAsString(Update.APK_PATH));
        insertOrUpdate.execute();
        return 1;
    }

    public Cursor query(String table, String[] projection, String selection,
            String[] selectionArgs, String groupBy, String having,
            String orderBy) {
        SQLiteDatabase db = getReadableDatabase();
        return db.query(table, projection, selection, selectionArgs, groupBy, having, orderBy);
    }

}
