package com.xiaomi.market.sdk;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lijie on 18-1-24.
 */

public class PkgUtils {
    private static final String TAG = "PkgUtils";

    public static String queryDefaultPackageForIntent(Intent intent) {
        List<ResolveInfo> resolveInfoList = queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : resolveInfoList) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo.enabled && activityInfo.exported) {
                return activityInfo.packageName;
            }
        }
        return null;
    }

    public static List<ResolveInfo> queryIntentActivities(Intent intent, int flag) {
        List<ResolveInfo> result = null;
        try {
            result = AppGlobal.getPackageManager().queryIntentActivities(intent, flag);
        } catch (Exception e) {
            Log.e(TAG, e.getMessage(), e);
        }
        return result != null ? result : new ArrayList<ResolveInfo>();
    }
}
