
package com.xiaomi.market.sdk;

public class Patcher {
    private static final String TAG = "MarketPatcher";

    /*
    public static void testPatch() {
        new Thread() {
            @Override
            public void run() {
                Patcher patcher = new Patcher();
                String oldFile = Environment.getExternalStorageDirectory() + "/old1.apk";
                String newFile = Environment.getExternalStorageDirectory() + "/new1.apk";
                String diffFile = Environment.getExternalStorageDirectory() + "/diff1.apk";
                Log.i(TAG, "START TO APPLY PATCH ...");
                long startTime = System.currentTimeMillis();
                patcher.applyPatch(oldFile, newFile, diffFile);
                long finishTime = System.currentTimeMillis();
                Log.i(TAG, "APPLYING PATCH FINISHED !");
                Log.i(TAG, "TIME USED : " + (finishTime - startTime) / 1000);
            }
        }.start();

    }
    */

    private static final String LIBRARY_NAME = "sdk_patcher_jni";

    public static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(LIBRARY_NAME);
        } catch (Throwable t) {
            Log.e(TAG, "load patcher library failed : " + t.toString());
            return false;
        }
        return true;
    }

    public static int patch(String oldFile, String newFile, String diffFile) {
        return new Patcher().applyPatch(oldFile, newFile, diffFile);
    }

    public native int applyPatch(String oldFile, String newFile, String diffFile);
}
