package com.xiaomi.market.sdk;

import android.text.TextUtils;

public class Log {
    private static final int MAX_CHAR_SIZE_PER_LOG = 3000;
    private static final String PREFIX = "UpdateCheck-";

    private static final int ERROR = 0;
    private static final int WARN = 1;
    private static final int INFO = 2;
    private static final int DEBUG = 3;
    private static final int VERBOSE = 4;

    public static boolean sEnable = Utils.DEBUG;

    public static void d(String tag, String msg) {
        if (sEnable) {
            log(addPrefix(tag), msg, DEBUG);
        }
    }

    public static void d(String tag, String msg, Throwable t) {
        if (sEnable) {
            log(addPrefix(tag), msg, t, DEBUG);
        }
    }

    public static void e(String tag, String msg) {
        if (sEnable) {
            log(addPrefix(tag), msg, ERROR);
        }
    }

    public static void e(String tag, String msg, Throwable t) {
        if (sEnable) {
            log(addPrefix(tag), msg, t, ERROR);
        }
    }

    public static void w(String tag, String msg) {
        if (sEnable) {
            log(addPrefix(tag), msg, WARN);
        }
    }

    public static void w(String tag, String msg, Throwable t) {
        if (sEnable) {
            log(addPrefix(tag), msg, t, WARN);
        }
    }

    public static void i(String tag, String msg) {
        if (sEnable) {
            log(addPrefix(tag), msg, INFO);
        }
    }

    public static void i(String tag, String msg, Throwable t) {
        if (sEnable) {
            log(addPrefix(tag), msg, t, INFO);
        }
    }

    public static void v(String tag, String msg) {
        if (sEnable) {
            log(addPrefix(tag), msg, VERBOSE);
        }
    }

    public static void v(String tag, String msg, Throwable t) {
        if (sEnable) {
            log(addPrefix(tag), msg, t, VERBOSE);
        }
    }

    private static void log(String tag, String msg, int level) {
        if (TextUtils.isEmpty(msg) || msg.length() <= MAX_CHAR_SIZE_PER_LOG) {
            logSubMessage(tag, msg, level);
        } else {
            for (int i = 0; i <= msg.length() / MAX_CHAR_SIZE_PER_LOG; i++) {
                int start = i * MAX_CHAR_SIZE_PER_LOG;
                int end = Math.min(msg.length(), (i + 1) * MAX_CHAR_SIZE_PER_LOG);
                if (start < end) {
                    String msgSub = msg.substring(start, end);
                    logSubMessage(tag, msgSub, level);
                }
            }
        }
    }

    private static void log(String tag, String msg, Throwable t, int level) {
        if (TextUtils.isEmpty(msg) || msg.length() <= MAX_CHAR_SIZE_PER_LOG) {
            logSubMessage(tag, msg, t, level);
        } else {
            for (int i = 0; i <= msg.length() / MAX_CHAR_SIZE_PER_LOG; i++) {
                int start = i * MAX_CHAR_SIZE_PER_LOG;
                int end = Math.min(msg.length(), (i + 1) * MAX_CHAR_SIZE_PER_LOG);
                if (start < end) {
                    String msgSub = msg.substring(start, end);
                    logSubMessage(tag, msgSub, t, level);
                }
            }
        }
    }

    private static void logSubMessage(String tag, String msgSub, int level) {
        if (msgSub == null) {
            msgSub = "";
        }
        switch (level) {
            case ERROR:
                android.util.Log.e(tag, msgSub);
                break;
            case WARN:
                android.util.Log.w(tag, msgSub);
                break;
            case INFO:
                android.util.Log.i(tag, msgSub);
                break;
            case DEBUG:
                android.util.Log.d(tag, msgSub);
                break;
            case VERBOSE:
                android.util.Log.v(tag, msgSub);
                break;
        }
    }

    private static void logSubMessage(String tag, String msgSub, Throwable t, int level) {
        if (msgSub == null) {
            msgSub = "";
        }
        switch (level) {
            case ERROR:
                android.util.Log.e(tag, msgSub, t);
                break;
            case WARN:
                android.util.Log.w(tag, msgSub, t);
                break;
            case INFO:
                android.util.Log.i(tag, msgSub, t);
                break;
            case DEBUG:
                android.util.Log.d(tag, msgSub, t);
                break;
            case VERBOSE:
                android.util.Log.v(tag, msgSub, t);
                break;
        }
    }

    public static String addPrefix(String tag) {
        return PREFIX + tag;
    }

}