package com.xiaomi.market.sdk;

import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;

/**
 * Created by lijie on 18-1-24.
 */

class DownloadInstallResultNotifier {
    public static final int ERROR_SDCARD_NOT_AVAILABLE = -1;
    public static final int ERROR_CONNECT_DOWNLOAD_MANAGER = -2;

    public static void notifyResult(int errorCode) {
        switch (errorCode) {
            case ERROR_SDCARD_NOT_AVAILABLE:
                showToast(R.string.xiaomi_update_sdk_external_storage_unavailable);
                break;

            case ERROR_CONNECT_DOWNLOAD_MANAGER:
                showToast(R.string.xiaomi_update_sdk_connect_download_manager_fail);
                break;
        }
    }

    private static void showToast(final int resId) {
        Handler handler = new Handler(Looper.getMainLooper());

        handler.post(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(AppGlobal.getContext(), resId, Toast.LENGTH_SHORT).show();
            }
        });
    }
}
