
package com.xiaomi.market.sdk;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

public class DownloadCompleteReceiver extends BroadcastReceiver {

    private static final String TAG = "MarketSDKDownloadReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (DownloadManager.ACTION_DOWNLOAD_COMPLETE.equals(action)) {
            long id = intent.getLongExtra(DownloadManager.EXTRA_DOWNLOAD_ID, -1);
            Log.d(TAG, "on sdk download complete : id = " + id);
            if (id == -1) {
                return;
            }
            DownloadInstallManager.getManager(context).handleDownloadComplete(id);
        }
    }
}
