
package com.xiaomi.market.sdk;

import android.text.TextUtils;

public class Constants {
    /**
     * URL to check update
     */
    public static final String PRODUCT_URL_DEFAULT = "https://api.developer.xiaomi.com/autoupdate/";

    public static final String PRODUCT_URL_BASE_GLOBAL = "https://global.developer.xiaomi.com/autoupdate/";

    public static final String STAGING_URL_BASE = "http://dev.staging.api.developer.n.xiaomi.com/autoupdate/";

    public static volatile String PRODUCT_URL_BASE;
    public static String UPDATE_URL;


    public static void setUseInternalProductUrl(boolean useInternalProductUrl) {
        PRODUCT_URL_BASE = useInternalProductUrl ? PRODUCT_URL_BASE_GLOBAL : PRODUCT_URL_DEFAULT;
    }

    public static void configURL() {
        if (Utils.STAGING) {
            UPDATE_URL = STAGING_URL_BASE + "updateself";
        } else {
            if (TextUtils.isEmpty(PRODUCT_URL_BASE)) {
                if (Client.isMiui() && SystemProperties.getString("ro.product.mod_device", "").contains("_global")) {
                    PRODUCT_URL_BASE = PRODUCT_URL_BASE_GLOBAL;
                } else {
                    PRODUCT_URL_BASE = PRODUCT_URL_DEFAULT;
                }
            }
            UPDATE_URL = PRODUCT_URL_BASE + "updateself";
        }
    }

    /**
     * base parameters
     */
    public static final String JSON_PACKAGE_NAME = "packageName";

    public static final String JSON_VERSION_CODE = "versionCode";

    public static final String JSON_OLD_APK_HASH = "apkHash";

    public static final String JSON_SIGNATURE = "signature";

    public static final String JSON_CLIENT_ID = "clientId";

    public static final String JSON_SDK_VERSION = "sdk";

    public static final String JSON_VERSION = "os";

    public static final String JSON_LANGUAGE = "la";

    public static final String JSON_COUNTRY = "co";

    public static final String JSON_XIAOMI_SDK_VERSION = "xiaomiSDKVersion";

    public static final String JSON_DEBUG = "debug";

    /**
     * filter parameters
     */
    public static final String JSON_FILTER_INFO = "info";

    public static final String JSON_SCREEN_SIZE = "screenSize";

    public static final String JSON_RESOLUTION = "resolution";

    public static final String JSON_DENSITY = "density";

    public static final String JSON_TOUCH_SCREEN = "touchScreen";

    public static final String JSON_GLES_VERSION = "glEsVersion";

    public static final String JSON_FEATURE = "feature";

    public static final String JSON_LIBRARY = "library";

    public static final String JSON_GL_EXTENSION = "glExtension";

    public static final String JSON_SDK = "sdk";

    public static final String JSON_SYSTEM_VERSION = "version";

    public static final String JSON_SYSTEM_RELEASE = "release";

    public static final String JSON_ANDROID_ID = "androidId";

    /**
     * response parameters
     */
    public static final String HOST = "host";

    public static final String FITNESS = "fitness";

    public static final String SOURCE = "source";

    public static final String UPDATE_LOG = "updateLog";

    public static final String VERSION_CODE = "versionCode";

    public static final String VERSION_NAME = "versionName";

    public static final String APK_URL = "apk";

    public static final String APK_HASH = "apkHash";

    public static final String APK_SIZE = "apkSize";

    public static final String DIFF_URL = "diffFile";

    public static final String DIFF_HASH = "diffFileHash";

    public static final String DIFF_SIZE = "diffFileSize";

    public interface BaseColumns {
        /**
         * The unique ID for a row.
         * <P>
         * Type: INTEGER (long)
         * </P>
         */
        public static final String _ID = "_id";
    }

    public static final class Update implements BaseColumns {
        public static final String TABLE = "update_download";

        public static final String PACKAGE_NAME = "package_name";

        public static final String DOWNLOAD_ID = "download_id";

        public static final String VERSION_CODE = "version_code";

        public static final String APK_URL = "apk_url";

        public static final String APK_HASH = "apk_hash";

        public static final String DIFF_URL = "diff_url";

        public static final String DIFF_HASH = "diff_hash";

        public static final String APK_PATH = "apk_path";

        public static final String CREATE_TABLE = "CREATE TABLE " + Update.TABLE + " (" +
                Update._ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                Update.PACKAGE_NAME + " TEXT," +
                Update.DOWNLOAD_ID + " INTEGER, " +
                Update.VERSION_CODE + " INTEGER, " +
                Update.APK_URL + " TEXT, " +
                Update.APK_HASH + " TEXT, " +
                Update.DIFF_URL + " TEXT, " +
                Update.DIFF_HASH + " TEXT, " +
                Update.APK_PATH + " TEXT, " +
                "UNIQUE(" + Update.PACKAGE_NAME + ")" +
                ");";

        public static final String[] UPDATE_PROJECTION = new String[] {
                TABLE + "." + PACKAGE_NAME,
                TABLE + "." + DOWNLOAD_ID,
                TABLE + "." + VERSION_CODE,
                TABLE + "." + APK_URL,
                TABLE + "." + APK_HASH,
                TABLE + "." + DIFF_URL,
                TABLE + "." + DIFF_HASH,
                TABLE + "." + APK_PATH
        };
    }

    public enum UpdateMethod {
        MARKET, DOWNLOAD_MANAGER
    }
}
