
package com.xiaomi.market.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public class Client {
    private static final String TAG = "MarketSdkClient";

    private static boolean mIsInited = false;

    static final int XIAOMI_SDK_VERSION_CODE = 4;

    /** 设备宽度（像素） */
    static int DISPLAY_WIDTH;

    /** 设备高度（像素） */
    static int DISPLAY_HEIGHT;

    /** 设备的高度*设备的宽度 */
    static String DISPLAY_RESOLUTION;

    /** 设备的像素密度dpi */
    static int DISPLAY_DENSITY;

    /**
     * 触摸屏类型，值为下列之一
     * undefined 0
     * notouch   1
     * stylus    2
     * finger    3
     */
    static int TOUCH_SCREEN;

    /** OpenGL Es版本号 */
    static String GLES_VERSION;

    /** 硬件/软件特性 */
    static ArrayList<String> FEATURE;

    /** 系统中包含的库 */
    static ArrayList<String> LIBRARY;

    /** OpenGL Extensions中的内容 */
    static ArrayList<String> GL_EXTENSION;

    /** 系统的sdk版本号 */
    static int SDK_VERSION;

    /** 系统的版本号（MIUI），例如2.7.13 */
    static String SYSTEM_VERSION;

    /** 系统的版本号（Android），例如4.0.4 */
    static String RELEASE;

    static String ANDROID_ID;

    /** 设置中的语言 */
    static String LANGUAGE;

    /** 设置中的国家 */
    static String COUNTRY;

    private static final Object mLock = new Object();

    static void init(Context context) {
        if (mIsInited) {
            return;
        }
        acquireScreenAttr(context);
        acquireDeviceConfig(context);
        acquireFeature(context);
        acquireLibrary(context);
        acquireGLExtensions();
        acquireSystemInfo(context);
        acquireUserInfo(context);
        acquireIdentity(context);
        mIsInited = true;
    }

    private static void acquireScreenAttr(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        wm.getDefaultDisplay().getMetrics(dm);
        DISPLAY_HEIGHT = dm.heightPixels;
        DISPLAY_WIDTH = dm.widthPixels;
        DISPLAY_RESOLUTION = DISPLAY_HEIGHT + "*" + DISPLAY_WIDTH;
        DISPLAY_DENSITY = dm.densityDpi;
    }

    private static void acquireDeviceConfig(Context context) {
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        TOUCH_SCREEN = info.reqTouchScreen;
        GLES_VERSION = info.getGlEsVersion();
    }

    private static void acquireFeature(Context context) {
        PackageManager pm = context.getPackageManager();
        FeatureInfo[] infos = pm.getSystemAvailableFeatures();
        synchronized (mLock) {
            FEATURE = new ArrayList<String>();
            if (infos != null) {
                for (FeatureInfo featureInfo : infos) {
                    if (!TextUtils.isEmpty(featureInfo.name)) {
                        FEATURE.add(featureInfo.name);
                    }
                }
            }
            Collections.sort(FEATURE);
        }
    }

    private static void acquireLibrary(Context context) {
        PackageManager pm = context.getPackageManager();
        String[] libraries = pm.getSystemSharedLibraryNames();
        synchronized (mLock) {
            LIBRARY = new ArrayList<String>();
            if (libraries != null) {
                for (String lib : libraries) {
                    if (!TextUtils.isEmpty(lib)) {
                        LIBRARY.add(lib);
                    }
                }
            }
            Collections.sort(LIBRARY);
        }
    }

    private static void acquireGLExtensions() {
        String glExtensions = getGLExtensions();
        synchronized (mLock) {
            GL_EXTENSION = new ArrayList<String>();
            if (!TextUtils.isEmpty(glExtensions)) {
                String[] extensions = TextUtils.split(glExtensions, " ");
                for (String exten : extensions) {
                    if (!TextUtils.isEmpty(exten)) {
                        GL_EXTENSION.add(exten);
                    }
                }
            }
            Collections.sort(GL_EXTENSION);
        }
    }

    private static void acquireSystemInfo(Context context) {
        RELEASE = Build.VERSION.RELEASE;
        SYSTEM_VERSION = Build.VERSION.INCREMENTAL;
        SDK_VERSION = Build.VERSION.SDK_INT;
    }

    private static void acquireUserInfo(Context context) {
        COUNTRY = Locale.getDefault().getCountry();
        LANGUAGE = Locale.getDefault().getLanguage();
    }

    private static void acquireIdentity(Context context) {
        ANDROID_ID = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
    }

    private static String getGLExtensions() {
        EGL10 egl = (EGL10) EGLContext.getEGL();
        EGLDisplay dpy = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (dpy == EGL10.EGL_NO_DISPLAY) {
            return null;
        }

        int[] version = new int[2];
        if (!egl.eglInitialize(dpy, version)) {
            return null;
        }
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        int[] configSpec = new int[] {
                EGL10.EGL_SURFACE_TYPE, EGL10.EGL_PBUFFER_BIT,
                EGL10.EGL_RED_SIZE, 8,
                EGL10.EGL_GREEN_SIZE, 8,
                EGL10.EGL_BLUE_SIZE, 8,
                EGL10.EGL_ALPHA_SIZE, 8,
                EGL10.EGL_NONE
        };
        EGLConfig config = null;
        if (!egl.eglChooseConfig(dpy, configSpec, configs, 1, configsCount)) {
            return null;
        } else if (configsCount[0] > 0) {
            config = configs[0];
        }

        EGLContext context = egl.eglCreateContext(dpy, config, EGL10.EGL_NO_CONTEXT, null);

        int[] attribListPbuffer = {
                EGL10.EGL_WIDTH, 480,
                EGL10.EGL_HEIGHT, 800,
                EGL10.EGL_NONE
        };
        EGLSurface surface = egl.eglCreatePbufferSurface(dpy, config, attribListPbuffer);

        if (surface == null || surface == EGL10.EGL_NO_SURFACE) {
            return null;
        }

        egl.eglMakeCurrent(dpy, surface, surface, context);
        if (!egl.eglMakeCurrent(dpy, surface, surface, context)) {
            return null;
        }

        GL10 gl = (GL10) context.getGL();

        String glstring = gl.glGetString(GL10.GL_EXTENSIONS);

        egl.eglDestroySurface(dpy, surface);
        egl.eglDestroyContext(dpy, context);
        egl.eglTerminate(dpy);

        return glstring != null ? glstring.trim() : null;
    }

    static boolean isLaterThanHoneycomb() {
        //int HONEYCOMB = 11
        return SDK_VERSION >= 11;
    }

    public static boolean isLaterThanN() {
        // int N = 24;
        return SDK_VERSION >= 24;
    }

    public static boolean isMiui() {
        // from MiuiSdk
        return new File("/system/app/miui.apk").exists() || new File("/system/app/miui/miui.apk").exists();
    }
}
