(ns spec-tools.spec
  (:refer-clojure :exclude [any? some? number? integer? int? pos-int? neg-int? nat-int?
                            float? double? boolean? string? ident? simple-ident? qualified-ident?
                            keyword? simple-keyword? qualified-keyword? symbol? simple-symbol?
                            qualified-symbol? uuid? uri? bigdec? inst? seqable? indexed?
                            map? vector? list? seq? char? set? nil? false? true? zero?
                            rational? coll? empty? associative? sequential? ratio? bytes?
                            #?@(:cljs [Inst Keyword UUID])])
  (:require [spec-tools.core :as st]))

(def any? (st/spec clojure.core/any?))
(def some? (st/spec clojure.core/some?))
(def number? (st/spec clojure.core/number?))
(def integer? (st/spec clojure.core/integer?))
(def int? (st/spec clojure.core/int?))
(def pos-int? (st/spec clojure.core/pos-int?))
(def neg-int? (st/spec clojure.core/neg-int?))
(def nat-int? (st/spec clojure.core/nat-int?))
(def float? (st/spec clojure.core/float?))
(def double? (st/spec clojure.core/double?))
(def boolean? (st/spec clojure.core/boolean?))
(def string? (st/spec clojure.core/string?))
(def ident? (st/spec clojure.core/ident?))
(def simple-ident? (st/spec clojure.core/simple-ident?))
(def qualified-ident? (st/spec clojure.core/qualified-ident?))
(def keyword? (st/spec clojure.core/keyword?))
(def simple-keyword? (st/spec clojure.core/simple-keyword?))
(def qualified-keyword? (st/spec clojure.core/qualified-keyword?))
(def symbol? (st/spec clojure.core/symbol?))
(def simple-symbol? (st/spec clojure.core/simple-symbol?))
(def qualified-symbol? (st/spec clojure.core/qualified-symbol?))
(def uuid? (st/spec clojure.core/uuid?))
#?(:clj (def uri? (st/spec clojure.core/uri?)))
#?(:clj (def bigdec? (st/spec clojure.core/bigdec?)))
(def inst? (st/spec clojure.core/inst?))
(def seqable? (st/spec clojure.core/seqable?))
(def indexed? (st/spec clojure.core/indexed?))
(def map? (st/spec clojure.core/map?))
(def vector? (st/spec clojure.core/vector?))
(def list? (st/spec clojure.core/list?))
(def seq? (st/spec clojure.core/seq?))
(def char? (st/spec clojure.core/char?))
(def set? (st/spec clojure.core/set?))
(def nil? (st/spec clojure.core/nil?))
(def false? (st/spec clojure.core/false?))
(def true? (st/spec clojure.core/true?))
(def zero? (st/spec clojure.core/zero?))
#?(:clj (def rational? (st/spec clojure.core/rational?)))
(def coll? (st/spec clojure.core/coll?))
(def empty? (st/spec clojure.core/empty?))
(def associative? (st/spec clojure.core/associative?))
(def sequential? (st/spec clojure.core/sequential?))
#?(:clj (def ratio? (st/spec clojure.core/ratio?)))
#?(:clj (def bytes? (st/spec clojure.core/bytes?)))
