/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.tools.compiler;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.metaclass.io.MetaClassIO;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.codehaus.metaclass.tools.compiler.CompilerMonitor;
import org.codehaus.metaclass.tools.compiler.DefaultCompilerMonitor;
import org.codehaus.metaclass.tools.compiler.JavaClassFilter;
import org.codehaus.metaclass.tools.compiler.MulticastJavaClassFilter;
import org.codehaus.metaclass.tools.packer.ClassDescriptorPacker;
import org.codehaus.metaclass.tools.qdox.QDoxAttributeInterceptor;
import org.codehaus.metaclass.tools.qdox.QDoxDescriptorParser;

public class ClassDescriptorCompiler {
    private static final QDoxDescriptorParser c_descriptorParser = new QDoxDescriptorParser();
    private boolean m_keepEmptyMethods;
    private File m_destDir;
    private MetaClassIO m_metaClassIO;
    private CompilerMonitor m_monitor = new DefaultCompilerMonitor();
    private final List m_sourceFiles = new ArrayList();
    private final List m_interceptors = new ArrayList();
    private final List m_filters = new ArrayList();

    public void setKeepEmptyMethods(boolean keepEmptyMethods) {
        this.m_keepEmptyMethods = keepEmptyMethods;
    }

    public void setMonitor(CompilerMonitor monitor) {
        if (null == monitor) {
            throw new NullPointerException("monitor");
        }
        this.m_monitor = monitor;
    }

    public void addSourceFile(File sourceFile) {
        if (null == sourceFile) {
            throw new NullPointerException("sourceFile");
        }
        this.m_sourceFiles.add(sourceFile);
    }

    public void addFilter(JavaClassFilter filter) {
        if (null == filter) {
            throw new NullPointerException("filter");
        }
        this.m_filters.add(filter);
    }

    public void addInterceptor(QDoxAttributeInterceptor interceptor) {
        if (null == interceptor) {
            throw new NullPointerException("interceptor");
        }
        this.m_interceptors.add(interceptor);
    }

    public void setDestDir(File destDir) {
        this.m_destDir = destDir;
    }

    public void setMetaClassIO(MetaClassIO metaClassIO) {
        if (null == metaClassIO) {
            throw new NullPointerException("metaClassIO");
        }
        this.m_metaClassIO = metaClassIO;
    }

    public MetaClassIO getMetaClassIO() {
        return this.m_metaClassIO;
    }

    public void execute() throws Exception {
        this.validate();
        this.processSourceFiles();
    }

    protected void processSourceFiles() {
        List classes = this.collectJavaClassesToSerialize();
        this.m_monitor.javaClassObjectsLoaded(classes);
        Set filteredClasses = this.filterJavaClassObjects(classes);
        this.m_monitor.postFilterJavaClassList(classes);
        List descriptors = this.buildClassDescriptors(filteredClasses);
        this.m_monitor.postBuildDescriptorsList(descriptors);
        Set output = this.compactClassDescriptors(descriptors);
        this.m_monitor.postCompactDescriptorsList(output);
        this.writeClassDescriptors(output);
    }

    private List buildClassDescriptors(Collection classes) {
        QDoxAttributeInterceptor[] interceptors = this.m_interceptors.toArray(new QDoxAttributeInterceptor[this.m_interceptors.size()]);
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            try {
                ClassDescriptor descriptor = c_descriptorParser.buildClassDescriptor(javaClass, interceptors);
                descriptors.add(descriptor);
            }
            catch (Throwable t) {
                String classname = javaClass.getFullyQualifiedName();
                this.m_monitor.errorGeneratingDescriptor(classname, t);
            }
        }
        return descriptors;
    }

    private void writeClassDescriptors(Collection classes) {
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)iterator.next();
            this.writeClassDescriptor(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List collectJavaClassesToSerialize() {
        JavaDocBuilder builder = new JavaDocBuilder();
        int count = this.m_sourceFiles.size();
        for (int i = 0; i < count; ++i) {
            File file = (File)this.m_sourceFiles.get(i);
            InputStream in = null;
            try {
                builder.addSource((Reader)new FileReader(file));
                continue;
            }
            catch (FileNotFoundException fnfe) {
                this.m_monitor.missingSourceFile(file);
                continue;
            }
            finally {
                this.shutdownStream(in);
            }
        }
        JavaSource[] sources = builder.getSources();
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        for (int i = 0; i < sources.length; ++i) {
            JavaClass[] javaClasses = sources[i].getClasses();
            for (int j = 0; j < javaClasses.length; ++j) {
                classes.add(javaClasses[j]);
            }
        }
        return classes;
    }

    private Set filterJavaClassObjects(List input) {
        JavaClassFilter[] filters = this.m_filters.toArray(new JavaClassFilter[this.m_filters.size()]);
        MulticastJavaClassFilter filter = new MulticastJavaClassFilter(filters);
        HashSet<JavaClass> classes = new HashSet<JavaClass>();
        int classCount = input.size();
        for (int i = 0; i < classCount; ++i) {
            JavaClass candidate = (JavaClass)input.get(i);
            JavaClass javaClass = filter.filterClass(candidate);
            if (null == javaClass) continue;
            classes.add(javaClass);
        }
        return classes;
    }

    private Set compactClassDescriptors(Collection input) {
        ClassDescriptorPacker packer = new ClassDescriptorPacker(this.m_keepEmptyMethods);
        HashSet<ClassDescriptor> classes = new HashSet<ClassDescriptor>();
        Iterator iterator = input.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor candidate = (ClassDescriptor)iterator.next();
            ClassDescriptor descriptor = packer.pack(candidate);
            if (null == descriptor) continue;
            classes.add(descriptor);
        }
        return classes;
    }

    private void validate() throws Exception {
        if (null == this.m_destDir) {
            String message = "DestDir not specified";
            throw new Exception("DestDir not specified");
        }
        if (this.m_destDir.exists() && !this.m_destDir.isDirectory()) {
            String message = "DestDir (" + this.m_destDir + ") is not a directory.";
            throw new Exception(message);
        }
        if (!this.m_destDir.exists() && !this.m_destDir.mkdirs()) {
            String message = "DestDir (" + this.m_destDir + ") could not be created.";
            throw new Exception(message);
        }
    }

    void writeClassDescriptor(ClassDescriptor descriptor) {
        try {
            this.m_metaClassIO.writeDescriptor(this.m_destDir, descriptor);
        }
        catch (Exception e) {
            this.m_monitor.errorWritingDescriptor(descriptor, e);
        }
    }

    void shutdownStream(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

