/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.introspector;

import java.io.File;
import java.io.InputStream;
import org.codehaus.metaclass.introspector.MetaClassAccessor;
import org.codehaus.metaclass.introspector.MetaClassException;
import org.codehaus.metaclass.io.MetaClassIO;
import org.codehaus.metaclass.io.MetaClassIOASM;
import org.codehaus.metaclass.io.MetaClassIOBinary;
import org.codehaus.metaclass.io.MetaClassIOXml;
import org.codehaus.metaclass.model.ClassDescriptor;

public class DefaultMetaClassAccessor
implements MetaClassAccessor {
    private static final MetaClassIO ASM_IO = DefaultMetaClassAccessor.getMetaClassIOASM();

    public ClassDescriptor getClassDescriptor(String classname, ClassLoader classLoader, MetaClassAccessor accessor) throws MetaClassException {
        ClassDescriptor descriptor = this.loadClassDescriptor(MetaClassIOXml.IO, classname, classLoader);
        if (null != descriptor) {
            return descriptor;
        }
        descriptor = this.loadClassDescriptor(MetaClassIOBinary.IO, classname, classLoader);
        if (null != descriptor) {
            return descriptor;
        }
        if (null != ASM_IO && null != (descriptor = this.loadClassDescriptor(ASM_IO, classname, classLoader))) {
            return descriptor;
        }
        String message = "Missing Attributes for " + classname;
        throw new MetaClassException(message);
    }

    private ClassDescriptor loadClassDescriptor(MetaClassIO io, String classname, ClassLoader classLoader) throws MetaClassException {
        String resourceName = io.getResourceName(classname).replace(File.separatorChar, '/');
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (null == inputStream) {
            return null;
        }
        try {
            return io.deserializeClass(inputStream);
        }
        catch (Exception e) {
            String message = "Unable to load Attributes for " + classname;
            throw new MetaClassException(message, e);
        }
    }

    private static MetaClassIO getMetaClassIOASM() {
        try {
            return MetaClassIOASM.IO;
        }
        catch (Exception e) {
            return null;
        }
    }
}

