/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.model;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public final class Attribute
implements Serializable {
    public static final Attribute[] EMPTY_SET = new Attribute[0];
    private static final String[] EMPTY_NAMES_SET = new String[0];
    private final String m_name;
    private final String m_value;
    private final Properties m_parameters;

    public Attribute(String name) {
        this(name, null, null);
    }

    public Attribute(String name, Properties parameters) {
        this(name, null, parameters);
    }

    public Attribute(String name, String value) {
        this(name, value, null);
    }

    private Attribute(String name, String value, Properties parameters) {
        if (null == name) {
            throw new NullPointerException("name");
        }
        this.m_name = name;
        this.m_value = value;
        this.m_parameters = parameters;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public int getParameterCount() {
        if (null == this.m_parameters) {
            return 0;
        }
        return ((Hashtable)this.m_parameters).size();
    }

    public String getParameter(String key) {
        if (null == this.m_parameters) {
            return null;
        }
        return this.m_parameters.getProperty(key);
    }

    public String getParameter(String key, String defaultValue) {
        if (null == this.m_parameters) {
            return defaultValue;
        }
        return this.m_parameters.getProperty(key, defaultValue);
    }

    public String[] getParameterNames() {
        if (null == this.m_parameters) {
            return EMPTY_NAMES_SET;
        }
        Set set = ((Hashtable)this.m_parameters).keySet();
        return set.toArray(EMPTY_NAMES_SET);
    }
}

