/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.codehaus.metaclass.io.AbstractMetaClassIO;
import org.codehaus.metaclass.model.Attribute;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.codehaus.metaclass.model.FieldDescriptor;
import org.codehaus.metaclass.model.MethodDescriptor;
import org.codehaus.metaclass.model.ParameterDescriptor;

public class MetaClassIOBinary
extends AbstractMetaClassIO {
    public static final MetaClassIOBinary IO = new MetaClassIOBinary();
    public static final String EXTENSION = "-meta.binary";
    static final int VERSION = 2;

    public String getResourceName(String classname) {
        return classname.replace('.', File.separatorChar) + EXTENSION;
    }

    public ClassDescriptor deserializeClass(InputStream input) throws IOException {
        DataInputStream data = new DataInputStream(input);
        this.checkVersionHeader(data);
        String classname = data.readUTF();
        Attribute[] classAttributes = this.readAttributes(data);
        FieldDescriptor[] fields = this.readFields(data);
        MethodDescriptor[] methods = this.readMethods(data);
        return new ClassDescriptor(classname, classAttributes, classAttributes, fields, methods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeClass(OutputStream output, ClassDescriptor descriptor) throws IOException {
        DataOutputStream data = new DataOutputStream(output);
        try {
            data.writeInt(2);
            data.writeUTF(descriptor.getName());
            this.writeAttributes(data, descriptor.getAttributes());
            this.writeFields(data, descriptor.getFields());
            this.writeMethods(data, descriptor.getMethods());
        }
        finally {
            data.flush();
        }
    }

    void writeFields(DataOutputStream data, FieldDescriptor[] fields) throws IOException {
        data.writeInt(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            this.writeField(data, field);
        }
    }

    private void writeField(DataOutputStream data, FieldDescriptor field) throws IOException {
        data.writeUTF(field.getName());
        data.writeUTF(field.getType());
        this.writeAttributes(data, field.getAttributes());
    }

    void writeMethods(DataOutputStream data, MethodDescriptor[] methods) throws IOException {
        data.writeInt(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            MethodDescriptor method = methods[i];
            this.writeMethod(data, method);
        }
    }

    private void writeMethod(DataOutputStream data, MethodDescriptor method) throws IOException {
        data.writeUTF(method.getName());
        data.writeUTF(method.getReturnType());
        this.writeParameters(data, method.getParameters());
        this.writeAttributes(data, method.getAttributes());
    }

    MethodDescriptor[] readMethods(DataInputStream data) throws IOException {
        int count = data.readInt();
        if (0 == count) {
            return MethodDescriptor.EMPTY_SET;
        }
        ArrayList<MethodDescriptor> methodSet = new ArrayList<MethodDescriptor>();
        for (int i = 0; i < count; ++i) {
            methodSet.add(this.readMethod(data));
        }
        return methodSet.toArray(new MethodDescriptor[methodSet.size()]);
    }

    private MethodDescriptor readMethod(DataInputStream data) throws IOException {
        String name = data.readUTF();
        String type = data.readUTF();
        ParameterDescriptor[] parameters = this.readParameters(data);
        Attribute[] attributes = this.readAttributes(data);
        return new MethodDescriptor(name, type, parameters, attributes, attributes);
    }

    FieldDescriptor[] readFields(DataInputStream data) throws IOException {
        int count = data.readInt();
        if (0 == count) {
            return FieldDescriptor.EMPTY_SET;
        }
        ArrayList<FieldDescriptor> fieldSet = new ArrayList<FieldDescriptor>();
        for (int i = 0; i < count; ++i) {
            fieldSet.add(this.readField(data));
        }
        return fieldSet.toArray(new FieldDescriptor[fieldSet.size()]);
    }

    private FieldDescriptor readField(DataInputStream data) throws IOException {
        String name = data.readUTF();
        String type = data.readUTF();
        Attribute[] attributes = this.readAttributes(data);
        return new FieldDescriptor(name, type, attributes, attributes);
    }

    ParameterDescriptor[] readParameters(DataInputStream data) throws IOException {
        int count = data.readInt();
        if (0 == count) {
            return ParameterDescriptor.EMPTY_SET;
        }
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        for (int i = 0; i < count; ++i) {
            parameters.add(this.readParameter(data));
        }
        return parameters.toArray(new ParameterDescriptor[parameters.size()]);
    }

    private ParameterDescriptor readParameter(DataInputStream data) throws IOException {
        String name = data.readUTF();
        String type = data.readUTF();
        return new ParameterDescriptor(name, type);
    }

    void writeParameters(DataOutputStream data, ParameterDescriptor[] parameters) throws IOException {
        data.writeInt(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            ParameterDescriptor parameter = parameters[i];
            this.writeParameter(data, parameter);
        }
    }

    private void writeParameter(DataOutputStream data, ParameterDescriptor parameter) throws IOException {
        data.writeUTF(parameter.getName());
        data.writeUTF(parameter.getType());
    }

    Attribute[] readAttributes(DataInputStream data) throws IOException {
        int count = data.readInt();
        if (0 == count) {
            return Attribute.EMPTY_SET;
        }
        ArrayList<Attribute> attributeSet = new ArrayList<Attribute>();
        for (int i = 0; i < count; ++i) {
            boolean valuePresent;
            String name = data.readUTF();
            String value = data.readUTF();
            Properties properties = this.readAttributeParameters(data);
            boolean bl = valuePresent = null != value && value.length() > 0;
            if (valuePresent && ((Hashtable)properties).size() > 0) {
                String message = "Cannot read attributes containing both text and parameters.";
                throw new IOException("Cannot read attributes containing both text and parameters.");
            }
            Attribute attribute = valuePresent ? new Attribute(name, value) : new Attribute(name, properties);
            attributeSet.add(attribute);
        }
        return attributeSet.toArray(new Attribute[attributeSet.size()]);
    }

    Properties readAttributeParameters(DataInputStream data) throws IOException {
        Properties parameters = new Properties();
        int count = data.readInt();
        for (int i = 0; i < count; ++i) {
            String name = data.readUTF();
            String value = data.readUTF();
            parameters.setProperty(name, value);
        }
        return parameters;
    }

    void writeAttributes(DataOutputStream data, Attribute[] attributes) throws IOException {
        data.writeInt(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            data.writeUTF(attribute.getName());
            String value = attribute.getValue();
            if (null != value) {
                data.writeUTF(value);
                this.writeAttributeParameters(data, null);
                continue;
            }
            data.writeUTF("");
            this.writeAttributeParameters(data, attribute);
        }
    }

    void writeAttributeParameters(DataOutputStream data, Attribute attribute) throws IOException {
        if (null == attribute) {
            data.writeInt(0);
        } else {
            String[] names = attribute.getParameterNames();
            data.writeInt(names.length);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String value = attribute.getParameter(name);
                data.writeUTF(name);
                data.writeUTF(value);
            }
        }
    }

    private void checkVersionHeader(DataInputStream data) throws IOException {
        int version = data.readInt();
        if (2 != version) {
            String message = "Version mismatch. Expected: 2 Actual: " + version;
            throw new IOException(message);
        }
    }
}

