/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.metaclass.introspector.MetaClassException;
import org.codehaus.metaclass.io.AddMetaDataAdapter;
import org.codehaus.metaclass.io.ExtractMetaDataVisitor;
import org.codehaus.metaclass.io.MetaClassIO;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class MetaClassIOASM
implements MetaClassIO {
    public static final MetaClassIOASM IO = new MetaClassIOASM();
    static final String ATTRIBUTE_NAME = "MetaClassDescriptor";
    private static final String EXTENSION = ".class";

    public String getResourceName(String classname) {
        return classname.replace('.', File.separatorChar) + EXTENSION;
    }

    public ClassDescriptor deserializeClass(InputStream input) throws Exception {
        ExtractMetaDataVisitor cv = this.visitClassFile(input);
        IOException ioe = cv.getIoe();
        ClassDescriptor descriptor = cv.getClassDescriptor();
        if (null != ioe) {
            throw new MetaClassException(ioe.getMessage(), ioe);
        }
        if (null == descriptor) {
            String message = "The .class file does not define MetaClass Descriptor Attribute.";
            throw new MetaClassException("The .class file does not define MetaClass Descriptor Attribute.");
        }
        return descriptor;
    }

    ExtractMetaDataVisitor visitClassFile(InputStream input) throws IOException {
        ClassReader reader = new ClassReader(input);
        ExtractMetaDataVisitor cv = new ExtractMetaDataVisitor();
        reader.accept((ClassVisitor)cv, false);
        return cv;
    }

    public void writeDescriptor(File baseDir, ClassDescriptor descriptor) throws Exception {
        String filename = this.getResourceName(descriptor.getName());
        File file = new File(baseDir, filename).getCanonicalFile();
        File backup = new File(baseDir, filename + ".bak").getCanonicalFile();
        if (!file.exists() || !file.isFile()) {
            String message = file + " is not a file";
            throw new Exception(message);
        }
        backup.delete();
        file.renameTo(backup);
        try {
            this.serializeDescriptor(file, backup, descriptor);
            backup.delete();
        }
        catch (Exception e) {
            file.delete();
            backup.renameTo(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeDescriptor(File input, File output, ClassDescriptor descriptor) throws Exception {
        FileInputStream inputStream;
        block5: {
            inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = new FileInputStream(output);
                outputStream = new FileOutputStream(input);
                this.serializeClass(inputStream, outputStream, descriptor);
                Object var7_6 = null;
                if (null == outputStream) break block5;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (null != outputStream) {
                    ((OutputStream)outputStream).close();
                }
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
                throw throwable;
            }
            ((OutputStream)outputStream).close();
        }
        if (null != inputStream) {
            ((InputStream)inputStream).close();
        }
    }

    public void serializeClass(InputStream input, OutputStream output, ClassDescriptor descriptor) throws Exception {
        ClassReader reader = new ClassReader(input);
        ClassWriter cw = new ClassWriter(true);
        AddMetaDataAdapter cv = new AddMetaDataAdapter((ClassVisitor)cw, descriptor);
        reader.accept((ClassVisitor)cv, false);
        byte[] bytes = cw.toByteArray();
        output.write(bytes);
        output.flush();
    }
}

