/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.codehaus.metaclass.io.MetaClassIOBinary;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;

class AddMetaDataAdapter
extends ClassAdapter {
    final ClassDescriptor m_descriptor;
    private IOException m_ioe;

    AddMetaDataAdapter(ClassVisitor cv, ClassDescriptor descriptor) {
        super(cv);
        this.m_descriptor = descriptor;
    }

    public void visitAttribute(Attribute attr) {
        if (!"MetaClassDescriptor".equals(attr.type)) {
            super.visitAttribute(attr);
        }
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        super.visit(access, name, superName, interfaces, sourceFile);
        try {
            byte[] bytes = this.toBytes();
            Attribute attr = new Attribute("MetaClassDescriptor", bytes, 0, bytes.length);
            super.visitAttribute(attr);
        }
        catch (IOException ioe) {
            this.m_ioe = ioe;
        }
    }

    byte[] toBytes() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        MetaClassIOBinary.IO.serializeClass(output, this.m_descriptor);
        byte[] bytes = output.toByteArray();
        return bytes;
    }

    IOException getIoe() {
        return this.m_ioe;
    }
}

