/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.introspector;

import org.codehaus.metaclass.introspector.CachingMetaClassAccessor;
import org.codehaus.metaclass.introspector.MetaClassAccessor;
import org.codehaus.metaclass.introspector.MetaClassException;
import org.codehaus.metaclass.introspector.WrapperMetaClassAccessor;
import org.codehaus.metaclass.model.ClassDescriptor;

public final class MetaClassIntrospector {
    private static final RuntimePermission CLEAR_CACHE_PERMISSION = new RuntimePermission("metaclass.clearCompleteCache");
    private static final RuntimePermission SET_ACCESSOR_PERMISSION = new RuntimePermission("metaclass.setAccessor");
    private static final CachingMetaClassAccessor c_cachingAccessor = new CachingMetaClassAccessor();
    private static final WrapperMetaClassAccessor c_wrapperAccessor = new WrapperMetaClassAccessor(c_cachingAccessor);

    public static synchronized void clearCompleteCache() {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(CLEAR_CACHE_PERMISSION);
        }
        c_cachingAccessor.clear();
    }

    public static void setAccessor(MetaClassAccessor accessor) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(SET_ACCESSOR_PERMISSION);
        }
        c_cachingAccessor.setAccessor(accessor);
    }

    public static ClassDescriptor getClassDescriptor(Class clazz) throws MetaClassException {
        return MetaClassIntrospector.getClassDescriptor(clazz.getName(), clazz.getClassLoader());
    }

    public static ClassDescriptor getClassDescriptor(String classname, ClassLoader classLoader) throws MetaClassException {
        return c_cachingAccessor.getClassDescriptor(classname, classLoader, c_wrapperAccessor);
    }
}

