/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.introspector;

import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.metaclass.introspector.DefaultMetaClassAccessor;
import org.codehaus.metaclass.introspector.MetaClassAccessor;
import org.codehaus.metaclass.introspector.MetaClassException;
import org.codehaus.metaclass.model.ClassDescriptor;

public class CachingMetaClassAccessor
implements MetaClassAccessor {
    private MetaClassAccessor m_accessor = new DefaultMetaClassAccessor();
    private final Map m_cache = new WeakHashMap();

    public synchronized void setAccessor(MetaClassAccessor accessor) {
        if (null == accessor) {
            throw new NullPointerException("accessor");
        }
        this.m_accessor = accessor;
    }

    public synchronized void clear() {
        this.m_cache.clear();
    }

    public synchronized ClassDescriptor getClassDescriptor(String classname, ClassLoader classLoader, MetaClassAccessor accessor) throws MetaClassException {
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        if (null == classLoader) {
            throw new NullPointerException("classLoader");
        }
        Map cache = this.getClassLoaderCache(classLoader);
        ClassDescriptor descriptor = (ClassDescriptor)cache.get(classname);
        if (null != descriptor) {
            return descriptor;
        }
        descriptor = this.m_accessor.getClassDescriptor(classname, classLoader, accessor);
        cache.put(classname, descriptor);
        return descriptor;
    }

    public synchronized void registerDescriptor(ClassDescriptor descriptor, ClassLoader classLoader) {
        if (null == descriptor) {
            throw new NullPointerException("descriptor");
        }
        if (null == classLoader) {
            throw new NullPointerException("classLoader");
        }
        Map cache = this.getClassLoaderCache(classLoader);
        cache.put(descriptor.getName(), descriptor);
    }

    private synchronized Map getClassLoaderCache(ClassLoader classLoader) {
        WeakHashMap map = (WeakHashMap)this.m_cache.get(classLoader);
        if (null == map) {
            map = new WeakHashMap();
            this.m_cache.put(classLoader, map);
        }
        return map;
    }
}

