/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.tools.tasks;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.codehaus.metaclass.tools.tasks.PluginElement;

public abstract class PluginSet
extends DataType {
    private final String m_type;
    private final ArrayList m_plugins = new ArrayList();
    private final ArrayList m_sets = new ArrayList();

    protected PluginSet(String type) {
        if (null == type) {
            throw new NullPointerException("type");
        }
        this.m_type = type;
    }

    void addPlugin(PluginElement element) {
        this.m_plugins.add(element);
    }

    void addPluginSet(PluginSet set) {
        this.m_sets.add(set);
    }

    Collection toPlugins() {
        ArrayList result = new ArrayList();
        Iterator elements = ((AbstractList)this.m_plugins).iterator();
        while (elements.hasNext()) {
            PluginElement element = (PluginElement)((Object)elements.next());
            if (null != element.getName()) continue;
            throw new BuildException(this.m_type + " must have a name");
        }
        result.addAll(this.m_plugins);
        Iterator iterator = ((AbstractList)this.m_sets).iterator();
        while (iterator.hasNext()) {
            PluginSet set = (PluginSet)((Object)iterator.next());
            result.addAll(set.toPlugins());
        }
        return result;
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.m_plugins.isEmpty() || !this.m_sets.isEmpty()) {
            throw this.tooManyAttributes();
        }
        Object object = reference.getReferencedObject(this.getProject());
        this.log("Referencing " + object, 4);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (!clazz.isInstance(object)) {
            String message = reference.getRefId() + " doesn't refer to a " + clazz.getName();
            throw new BuildException(message);
        }
        PluginSet other = (PluginSet)((Object)object);
        this.m_plugins.addAll(other.m_plugins);
        this.m_sets.addAll(other.m_sets);
        super.setRefid(reference);
    }
}

