/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.tools.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.metaclass.io.MetaClassIO;
import org.codehaus.metaclass.io.MetaClassIOASM;
import org.codehaus.metaclass.io.MetaClassIOBinary;
import org.codehaus.metaclass.io.MetaClassIOXml;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.codehaus.metaclass.tools.compiler.ClassDescriptorCompiler;
import org.codehaus.metaclass.tools.compiler.CompilerMonitor;
import org.codehaus.metaclass.tools.compiler.JavaClassFilter;
import org.codehaus.metaclass.tools.qdox.NonNamespaceAttributeRemovingInterceptor;
import org.codehaus.metaclass.tools.qdox.QDoxAttributeInterceptor;
import org.codehaus.metaclass.tools.tasks.FilterSet;
import org.codehaus.metaclass.tools.tasks.FormatEnum;
import org.codehaus.metaclass.tools.tasks.InterceptorSet;
import org.codehaus.metaclass.tools.tasks.PluginElement;

public class GenerateClassDescriptorsTask
extends Task
implements CompilerMonitor {
    public static final int CLASS_TYPE = 0;
    public static final int BINARY_TYPE = 1;
    public static final int XML_TYPE = 2;
    private File m_destDir;
    private int m_format = 0;
    private boolean m_keepEmptyMethods = false;
    private boolean m_namespaceTagsOnly = true;
    private final FilterSet m_filterSet = new FilterSet();
    private final InterceptorSet m_interceptorSet = new InterceptorSet();
    private boolean m_failed;
    private final ClassDescriptorCompiler m_compiler = new ClassDescriptorCompiler();
    private final List m_filesets = new ArrayList();
    static /* synthetic */ Class class$org$codehaus$metaclass$tools$compiler$JavaClassFilter;
    static /* synthetic */ Class class$org$codehaus$metaclass$tools$qdox$QDoxAttributeInterceptor;

    public void setProject(Project project) {
        super.setProject(project);
        this.m_filterSet.setProject(project);
        this.m_interceptorSet.setProject(project);
    }

    public void addFilter(PluginElement element) {
        this.m_filterSet.addFilter(element);
    }

    public void addFilterSet(FilterSet set) {
        this.m_filterSet.addFilterSet(set);
    }

    public void addInterceptor(PluginElement element) {
        this.m_interceptorSet.addInterceptor(element);
    }

    public void addInterceptorSet(InterceptorSet set) {
        this.m_interceptorSet.addInterceptorSet(set);
    }

    public void addFileset(FileSet fileSet) {
        this.m_filesets.add(fileSet);
    }

    public void setDestDir(File destDir) {
        this.m_destDir = destDir;
    }

    public void setFormat(FormatEnum format) {
        this.m_format = format.getTypeCode();
    }

    public void setKeepEmptyMethods(boolean keepEmptyMethods) {
        this.m_keepEmptyMethods = keepEmptyMethods;
    }

    public void setNamespaceTagsOnly(boolean namespaceTagsOnly) {
        this.m_namespaceTagsOnly = namespaceTagsOnly;
    }

    public void execute() {
        this.setupFilters();
        this.setupInterceptors();
        if (this.m_namespaceTagsOnly) {
            this.m_compiler.addInterceptor(NonNamespaceAttributeRemovingInterceptor.INTERCEPTOR);
        }
        this.m_compiler.setDestDir(this.m_destDir);
        this.m_compiler.setMonitor(this);
        this.m_compiler.setKeepEmptyMethods(this.m_keepEmptyMethods);
        this.setupTarget();
        this.setupFileList();
        try {
            this.m_compiler.execute();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
        if (this.m_failed) {
            String message = "Error generating ClassDescriptors";
            throw new BuildException("Error generating ClassDescriptors");
        }
    }

    private void setupFileList() {
        int count = this.m_filesets.size();
        for (int i = 0; i < count; ++i) {
            FileSet fileSet = (FileSet)this.m_filesets.get(i);
            this.appendFileSetToCompiler(fileSet);
        }
    }

    private void appendFileSetToCompiler(FileSet fileSet) {
        File dir = fileSet.getDir(this.getProject());
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        for (int j = 0; j < includedFiles.length; ++j) {
            File file = new File(dir, includedFiles[j]);
            this.m_compiler.addSourceFile(file);
        }
    }

    void setupTarget() {
        if (0 == this.m_format) {
            this.m_compiler.setMetaClassIO((MetaClassIO)MetaClassIOASM.IO);
        } else if (1 == this.m_format) {
            this.m_compiler.setMetaClassIO((MetaClassIO)MetaClassIOBinary.IO);
        } else {
            this.m_compiler.setMetaClassIO((MetaClassIO)MetaClassIOXml.IO);
        }
    }

    private void setupFilters() {
        Collection collection = this.m_filterSet.toPlugins();
        this.log("Using " + collection.size() + " Filters", 3);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PluginElement element = (PluginElement)((Object)iterator.next());
            JavaClassFilter filter = (JavaClassFilter)this.createInstance(element, class$org$codehaus$metaclass$tools$compiler$JavaClassFilter == null ? GenerateClassDescriptorsTask.class$("org.codehaus.metaclass.tools.compiler.JavaClassFilter") : class$org$codehaus$metaclass$tools$compiler$JavaClassFilter, "filter");
            this.log("Adding Filter " + filter, 4);
            this.m_compiler.addFilter(filter);
        }
    }

    private void setupInterceptors() {
        Collection collection = this.m_interceptorSet.toPlugins();
        this.log("Using " + collection.size() + " Interceptors", 3);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PluginElement element = (PluginElement)((Object)iterator.next());
            QDoxAttributeInterceptor interceptor = (QDoxAttributeInterceptor)this.createInstance(element, class$org$codehaus$metaclass$tools$qdox$QDoxAttributeInterceptor == null ? GenerateClassDescriptorsTask.class$("org.codehaus.metaclass.tools.qdox.QDoxAttributeInterceptor") : class$org$codehaus$metaclass$tools$qdox$QDoxAttributeInterceptor, "interceptor");
            this.log("Adding Interceptor " + interceptor, 4);
            this.m_compiler.addInterceptor(interceptor);
        }
    }

    Object createInstance(PluginElement element, Class type, String description) {
        String name = element.getName();
        AntClassLoader loader = this.createLoader(element);
        try {
            Object object = loader.loadClass(name).newInstance();
            if (!type.isInstance(object)) {
                String message = "Error creating " + description + " " + name + " as it does not implement " + type.getName() + ".";
                this.log(message);
                throw new BuildException(message);
            }
            return object;
        }
        catch (Exception e) {
            String message = "Error creating " + description + " " + name;
            this.log(message);
            throw new BuildException(message, (Throwable)e);
        }
    }

    private AntClassLoader createLoader(PluginElement element) {
        Path path = element.getPath();
        if (null == path) {
            path = new Path(this.getProject());
        }
        return new AntClassLoader(this.getClass().getClassLoader(), this.getProject(), path, true);
    }

    final String getOutputDescription() {
        if (2 == this.m_format) {
            return "xml";
        }
        return "binary";
    }

    public void errorWritingDescriptor(ClassDescriptor descriptor, Exception e) {
        this.log("Error writing descriptor for " + descriptor.getName() + " due to " + e, 0);
        this.m_failed = true;
    }

    public void missingSourceFile(File file) {
        this.log("Missing Source file " + file, 0);
        this.m_failed = true;
    }

    public void javaClassObjectsLoaded(Collection classes) {
        this.log("Loaded " + classes.size() + " Java classes.", 4);
    }

    public void postFilterJavaClassList(Collection classes) {
        this.log("MetaClass Attributes Compiler building " + classes.size() + " " + this.getOutputDescription() + " descriptors.", 4);
    }

    public void postBuildDescriptorsList(Collection descriptors) {
    }

    public void postCompactDescriptorsList(Collection descriptors) {
        this.log("MetaClass Attributes Compiler writing " + descriptors.size() + " " + this.getOutputDescription() + " descriptors.", 2);
    }

    public void errorGeneratingDescriptor(String classname, Throwable t) {
        this.log("Error Generating decriptor for  " + classname + ". Reason: " + t, 0);
        this.m_failed = true;
    }

    protected final ClassDescriptorCompiler getCompiler() {
        return this.m_compiler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

