/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.tools.packer;

import java.util.ArrayList;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.codehaus.metaclass.model.FeatureDescriptor;
import org.codehaus.metaclass.model.FieldDescriptor;
import org.codehaus.metaclass.model.MethodDescriptor;

public class ClassDescriptorPacker {
    private final boolean m_keepEmptyMethods;

    public ClassDescriptorPacker(boolean keepEmptyMethods) {
        this.m_keepEmptyMethods = keepEmptyMethods;
    }

    public ClassDescriptor pack(ClassDescriptor descriptor) {
        FieldDescriptor[] fields = this.packFields(descriptor.getFields());
        MethodDescriptor[] methods = this.packMethods(descriptor.getMethods());
        if (0 == fields.length && 0 == methods.length && this.isEmpty((FeatureDescriptor)descriptor)) {
            return null;
        }
        return new ClassDescriptor(descriptor.getName(), descriptor.getDeclaredAttributes(), descriptor.getAttributes(), fields, methods);
    }

    MethodDescriptor[] packMethods(MethodDescriptor[] methods) {
        if (this.m_keepEmptyMethods) {
            return methods;
        }
        ArrayList<MethodDescriptor> set = new ArrayList<MethodDescriptor>();
        for (int i = 0; i < methods.length; ++i) {
            MethodDescriptor method = methods[i];
            if (this.isEmpty((FeatureDescriptor)method)) continue;
            set.add(method);
        }
        return set.toArray(new MethodDescriptor[set.size()]);
    }

    FieldDescriptor[] packFields(FieldDescriptor[] fields) {
        ArrayList<FieldDescriptor> set = new ArrayList<FieldDescriptor>();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            if (this.isEmpty((FeatureDescriptor)field)) continue;
            set.add(field);
        }
        return set.toArray(new FieldDescriptor[set.size()]);
    }

    boolean isEmpty(FeatureDescriptor descriptor) {
        return 0 == descriptor.getAttributes().length && 0 == descriptor.getDeclaredAttributes().length;
    }
}

