/*
 * Decompiled with CFR 0.152.
 */
package net.sf.maventaglib;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import net.sf.maventaglib.TaglibPlugin;
import net.sf.maventaglib.checker.Tld;
import net.sf.maventaglib.checker.TldChecker;
import net.sf.maventaglib.checker.TldParser;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;

public class TaglibValidatePlugin
extends TaglibPlugin {
    protected String report;

    public void setReport(String file) {
        this.report = file;
    }

    public void execute() throws Exception {
        File srcDirFile = new File(this.srcDir);
        File outFile = new File(this.report);
        this.echo("Validating tld files in " + srcDirFile.getAbsolutePath());
        if (!srcDirFile.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + srcDirFile.getAbsolutePath());
        }
        File[] files = srcDirFile.listFiles();
        DocumentBuilder builder = this.getDocumentBuilder();
        ArrayList<Tld> tldList = new ArrayList<Tld>();
        for (int i = 0; i < files.length; ++i) {
            File current = files[i];
            if (current.isDirectory() || !current.getName().toLowerCase().endsWith(".tld")) continue;
            org.w3c.dom.Document tldDoc = builder.parse(current);
            Tld tld = TldParser.parse(tldDoc, current.getName());
            tldList.add(tld);
        }
        if (tldList.size() == 0) {
            this.echo("No tlds found in " + srcDirFile.getAbsolutePath() + "!");
            return;
        }
        TldChecker checker = new TldChecker();
        Document checked = checker.check(tldList.toArray(new Tld[tldList.size()]));
        this.applyXslt((Source)new DocumentSource(checked), "/taglibvalidate.xsl", outFile);
    }
}

